# Setaragan Zirak Private School Website

A modern, responsive website for **Setaragan Zirak Private School** in Kabul, Afghanistan, built with Next.js, TypeScript, and Tailwind CSS.

![Next.js](https://img.shields.io/badge/Next.js-15.5-black?style=flat-square&logo=next.js)
![TypeScript](https://img.shields.io/badge/TypeScript-5.0-blue?style=flat-square&logo=typescript)
![Tailwind CSS](https://img.shields.io/badge/Tailwind-4.0-38bdf8?style=flat-square&logo=tailwind-css)

---

## 🏫 About the Project

This website serves as the digital presence for Setaragan Zirak Private School, showcasing:
- School programs and educational services
- Faculty team and leadership
- Student stories and achievements
- News and announcements
- Facilities and campus information
- Admission process and requirements
- Donation opportunities for student support

---

## 🚀 Quick Start

### Prerequisites
- Node.js 18+ 
- npm, yarn, or pnpm

### Installation

```bash
# Clone the repository
git clone https://github.com/alirazar10/setaraganzirakschool.git

# Navigate to project directory
cd setaraganzirakschool

# Install dependencies
npm install
# or
yarn install
# or
pnpm install
```

### Development Server

First, run the development server:

```bash
npm run dev
# or
yarn dev
# or
pnpm dev
```

Open [http://localhost:3000](http://localhost:3000) to view the website.

### Build for Production

```bash
npm run build
npm run start
```

---

## 📁 Project Structure

```
setaraganzirakschool/
├── src/
│   ├── app/                    # Next.js App Router pages
│   │   ├── page.tsx           # Home page
│   │   ├── about/             # About page
│   │   ├── team/              # Team & individual teacher pages
│   │   ├── students/          # Student stories
│   │   ├── services/          # Services & programs
│   │   ├── online-school/     # Online school info
│   │   ├── facilities/        # Facilities showcase
│   │   ├── news/              # News listing & articles
│   │   ├── contact/           # Contact page
│   │   ├── donate/            # Donation page
│   │   └── admissions/        # Admissions info
│   ├── components/
│   │   ├── common/            # Reusable components
│   │   │   ├── layout/        # Header, Footer, AppLayout
│   │   │   └── ui/            # Button, Card, Badge, etc.
│   │   └── pages/             # Page-specific components
│   ├── constants/             # JSON data (teachers)
│   ├── lib/                   # Utilities & helpers
│   └── types/                 # TypeScript types
├── public/
│   ├── images/                # Static images
│   └── teachers_data/         # Teacher profile images
└── database/                  # Database schema

```

---

## 🎨 Key Features

### ✅ Implemented
- 🏠 **13 Core Pages** - Complete website structure
- 👨‍🏫 **Dynamic Teacher Profiles** - Individual pages for each teacher
- 📰 **News System** - Article listing, search, filtering, and individual articles
- 📱 **Fully Responsive** - Mobile-first design with Tailwind CSS
- 🎯 **Unified Typography** - Consistent design system
- 🖼️ **Image Optimization** - Next.js Image component with fallbacks
- ♿ **Accessibility** - ARIA labels, focus states, keyboard navigation
- 🔄 **Smooth Animations** - Transitions and hover effects
- 📊 **Mock Data System** - Ready for CMS integration

### 🚧 Coming Soon
- 🌐 **Multilingual Support** - English, Dari, Pashto
- 💳 **Payment Integration** - For donations
- 📧 **Form Backends** - Contact and newsletter functionality
- 🔗 **CMS Integration** - WordPress/Supabase connection
- 📈 **Analytics** - Visitor tracking and insights
- 🔍 **SEO Optimization** - Enhanced meta tags and sitemaps

---

## 🛠️ Tech Stack

- **Framework**: [Next.js 15.5](https://nextjs.org/) (App Router)
- **Language**: [TypeScript 5](https://www.typescriptlang.org/)
- **Styling**: [Tailwind CSS 4](https://tailwindcss.com/)
- **UI Components**: Custom components with Radix UI primitives
- **Icons**: [Lucide React](https://lucide.dev/)
- **Image Handling**: Next.js Image optimization
- **Backend** (Planned): [Supabase](https://supabase.com/)
- **Deployment**: [Vercel](https://vercel.com/) (Planned)

---

## 📝 Available Scripts

```bash
# Development
npm run dev          # Start dev server with Turbopack

# Production
npm run build        # Build for production
npm run start        # Start production server

# Code Quality
npm run lint         # Run ESLint
```

---

## 🌍 Environment Variables

Create a `.env.local` file in the root directory:

```env
# Supabase (Coming Soon)
NEXT_PUBLIC_SUPABASE_URL=your_supabase_url
NEXT_PUBLIC_SUPABASE_ANON_KEY=your_supabase_anon_key

# Email Service (Coming Soon)
EMAIL_SERVICE_API_KEY=your_email_api_key

# Analytics (Coming Soon)
NEXT_PUBLIC_GA_ID=your_google_analytics_id
```

---

## 📚 Documentation

For detailed project documentation, see:
- [Project Instructions](.github/copilot-instructions.md) - Full project overview and checklist
- [Database Schema](database/schema.sql) - Database structure (planned)

---

## 🤝 Contributing

This is a private school project. For contributions or suggestions, please contact the school administration.

---

## 📧 Contact

**Setaragan Zirak Private School**
- 📍 Market Safid Street, 2nd Phase, Omid-e-Sabz Township, Darullaman, Kabul, Afghanistan
- 📞 +93747500432
- 📧 setaraganzirak98@gmail.com

---

## 📄 License

This project is private and proprietary to Setaragan Zirak Private School.

---

## 🙏 Acknowledgments

- School administration and faculty for providing content
- Students and families for their stories and testimonials
- Development team for building this platform

---

**Built with ❤️ for education in Afghanistan**

---

## 📊 Project Status

- **Version**: 0.1.0 (Development)
- **Status**: ~60% Complete
- **Last Updated**: October 21, 2025

For detailed progress tracking, see the [Project Checklist](.github/copilot-instructions.md).

---

Open [http://localhost:3000](http://localhost:3000) with your browser to see the result.

You can start editing the page by modifying `app/page.tsx`. The page auto-updates as you edit the file.

This project uses [`next/font`](https://nextjs.org/docs/app/building-your-application/optimizing/fonts) to automatically optimize and load [Geist](https://vercel.com/font), a new font family for Vercel.

## Learn More

To learn more about Next.js, take a look at the following resources:

- [Next.js Documentation](https://nextjs.org/docs) - learn about Next.js features and API.
- [Learn Next.js](https://nextjs.org/learn) - an interactive Next.js tutorial.

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js) - your feedback and contributions are welcome!

## Deploy on Vercel

The easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new?utm_medium=default-template&filter=next.js&utm_source=create-next-app&utm_campaign=create-next-app-readme) from the creators of Next.js.

Check out our [Next.js deployment documentation](https://nextjs.org/docs/app/building-your-application/deploying) for more details.
