-- DropIndex
DROP INDEX `news_articles_authorId_fkey` ON `news_articles`;

-- CreateTable
CREATE TABLE `students_in_need` (
    `id` VARCHAR(191) NOT NULL,
    `name` VARCHAR(191) NOT NULL,
    `grade` VARCHAR(191) NULL,
    `year` VARCHAR(191) NULL,
    `story` LONGTEXT NOT NULL,
    `background` TEXT NULL,
    `specificNeed` VARCHAR(191) NULL,
    `achievements` TEXT NULL,
    `images` TEXT NULL,
    `needCategory` VARCHAR(191) NOT NULL DEFAULT 'education',
    `contactInfo` VARCHAR(191) NULL,
    `featured` BOOLEAN NOT NULL DEFAULT false,
    `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3),
    `updatedAt` DATETIME(3) NOT NULL,

    INDEX `students_in_need_featured_idx`(`featured`),
    INDEX `students_in_need_needCategory_idx`(`needCategory`),
    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- AddForeignKey
ALTER TABLE `news_articles` ADD CONSTRAINT `news_articles_authorId_fkey` FOREIGN KEY (`authorId`) REFERENCES `admin_users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;
