/*
  Warnings:

  - You are about to drop the column `supportNeeded` on the `students` table. All the data in the column will be lost.

*/
-- DropIndex
DROP INDEX `news_articles_authorId_fkey` ON `news_articles`;

-- AlterTable
ALTER TABLE `admin_users` ADD COLUMN `approvalDate` DATETIME(3) NULL,
    ADD COLUMN `approvedBy` VARCHAR(191) NULL,
    ADD COLUMN `loginCount` INTEGER NOT NULL DEFAULT 0,
    ADD COLUMN `rejectionReason` TEXT NULL,
    ADD COLUMN `status` VARCHAR(191) NOT NULL DEFAULT 'pending',
    MODIFY `role` VARCHAR(191) NOT NULL DEFAULT 'editor',
    MODIFY `active` BOOLEAN NOT NULL DEFAULT false;

-- AlterTable
ALTER TABLE `students` DROP COLUMN `supportNeeded`;

-- CreateIndex
CREATE INDEX `admin_users_status_idx` ON `admin_users`(`status`);

-- CreateIndex
CREATE INDEX `admin_users_role_idx` ON `admin_users`(`role`);

-- CreateIndex
CREATE INDEX `admin_users_active_idx` ON `admin_users`(`active`);

-- AddForeignKey
ALTER TABLE `admin_users` ADD CONSTRAINT `admin_users_approvedBy_fkey` FOREIGN KEY (`approvedBy`) REFERENCES `admin_users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `news_articles` ADD CONSTRAINT `news_articles_authorId_fkey` FOREIGN KEY (`authorId`) REFERENCES `admin_users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;
