-- DropIndex
DROP INDEX `admin_users_approvedBy_fkey` ON `admin_users`;

-- DropIndex
DROP INDEX `news_articles_authorId_fkey` ON `news_articles`;

-- AlterTable
ALTER TABLE `site_settings` ADD COLUMN `type` VARCHAR(191) NOT NULL DEFAULT 'general';

-- CreateIndex
CREATE INDEX `site_settings_type_idx` ON `site_settings`(`type`);

-- AddForeignKey
ALTER TABLE `admin_users` ADD CONSTRAINT `admin_users_approvedBy_fkey` FOREIGN KEY (`approvedBy`) REFERENCES `admin_users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE `news_articles` ADD CONSTRAINT `news_articles_authorId_fkey` FOREIGN KEY (`authorId`) REFERENCES `admin_users`(`id`) ON DELETE SET NULL ON UPDATE CASCADE;
