import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function main() {
  console.log('Seeding contact settings...');

  // Contact information settings
  const contactSettings = [
    {
      key: 'contact_address_line1',
      value: 'Market Safid Street, 2nd Phase, Omid-e-Sabz Township',
      type: 'contact',
      description: 'Contact address line 1'
    },
    {
      key: 'contact_address_line2',
      value: 'Darullaman, Kabul, Afghanistan',
      type: 'contact',
      description: 'Contact address line 2'
    },
    {
      key: 'contact_phone_primary',
      value: '+93747500432',
      type: 'contact',
      description: 'Primary phone number'
    },
    {
      key: 'contact_phone_whatsapp',
      value: '+93785675793',
      type: 'contact',
      description: 'WhatsApp phone number'
    },
    {
      key: 'contact_email',
      value: 'setaraganzirak98@gmail.com',
      type: 'contact',
      description: 'Contact email address'
    },
    {
      key: 'contact_hours_weekday',
      value: 'Monday - Friday: 8:00 AM - 4:00 PM',
      type: 'contact',
      description: 'Weekday office hours'
    },
    {
      key: 'contact_hours_saturday',
      value: 'Saturday: 9:00 AM - 1:00 PM',
      type: 'contact',
      description: 'Saturday office hours'
    },
    {
      key: 'contact_hours_sunday',
      value: 'Sunday: Closed',
      type: 'contact',
      description: 'Sunday office hours'
    },
    {
      key: 'social_facebook',
      value: 'https://facebook.com/profile.php?id=100063987887508',
      type: 'contact',
      description: 'Facebook page URL'
    },
    {
      key: 'social_linkedin',
      value: 'https://www.linkedin.com/in/azizllah-paeyndah-5048a1250',
      type: 'contact',
      description: 'LinkedIn profile URL'
    },
    {
      key: 'social_whatsapp',
      value: 'https://wa.me/93785675793',
      type: 'contact',
      description: 'WhatsApp contact URL'
    },
    {
      key: 'contact_response_time',
      value: 'We typically respond within 24-48 hours during business days.',
      type: 'contact',
      description: 'Response time message'
    },
    {
      key: 'contact_best_time',
      value: 'Monday to Friday, 9:00 AM - 3:00 PM (Local Time)',
      type: 'contact',
      description: 'Best time to call message'
    },
    {
      key: 'contact_map_embed',
      value: 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3290.1915100927563!2d69.07643857664463!3d34.478862595081864!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x38d1676a53ac71b1%3A0xdffb8f70f4074636!2sSetaragan%20Zirak%20Private%20High%20School!5e0!3m2!1sen!2s!4v1757971730858!5m2!1sen!2s',
      type: 'map',
      description: 'Google Maps embed URL'
    }
  ];

  // Upsert each setting
  for (const setting of contactSettings) {
    await prisma.siteSettings.upsert({
      where: { key: setting.key },
      update: { 
        value: setting.value,
        type: setting.type,
        description: setting.description 
      },
      create: setting,
    });
  }

  console.log('✅ Contact settings seeded successfully');
}

main()
  .catch((e) => {
    console.error('Error seeding contact settings:', e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
