import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function seedHeroSlides() {
  console.log('Seeding hero slides...');

  const slides = [
    {
      title: 'Our Campus',
      description: 'Modern learning environment',
      imageUrl: '/images/home/hom1-edited.avif',
      alt: 'Setaragan Zirak School Main Building',
      order: 0,
      active: true,
    },
    {
      title: 'Quality Education',
      description: 'Empowering young minds',
      imageUrl: '/images/home/hom2-768x1024.avif',
      alt: 'Students Learning Together',
      order: 1,
      active: true,
    },
    {
      title: 'Our Students',
      description: 'Building futures through education',
      imageUrl: '/images/home/raihana-768x1024.avif',
      alt: 'Happy Student',
      order: 2,
      active: true,
    },
    {
      title: 'Science Laboratory',
      description: 'Hands-on learning experiences',
      imageUrl: '/images/home/Science-Lab-new-photo-.avif',
      alt: 'Modern Science Laboratory',
      order: 3,
      active: true,
    },
    {
      title: 'Beneficiaries',
      description: 'Making a difference in lives',
      imageUrl: '/images/home/sz-bene-768x1024.avif',
      alt: 'Beneficiary Students',
      order: 4,
      active: true,
    },
  ];

  for (const slide of slides) {
    await prisma.heroSlide.upsert({
      where: { id: `seed-${slide.order}` },
      update: slide,
      create: {
        id: `seed-${slide.order}`,
        ...slide,
      },
    });
  }

  console.log('✅ Hero slides seeded successfully');
}

seedHeroSlides()
  .catch((e) => {
    console.error('❌ Error seeding hero slides:', e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
