import { PrismaClient } from '@prisma/client';

const prisma = new PrismaClient();

async function seedLogoSettings() {
  console.log('Seeding logo settings...');

  const logoSettings = [
    {
      key: 'logo_url',
      value: '',
      type: 'brand',
      description: 'Main logo image URL',
    },
    {
      key: 'logo_text',
      value: 'Setaragan Zirak',
      type: 'brand',
      description: 'Logo text displayed with or without image',
    },
    {
      key: 'logo_initials',
      value: 'SZ',
      type: 'brand',
      description: 'Logo initials for mobile/small displays',
    },
    {
      key: 'favicon_url',
      value: '',
      type: 'brand',
      description: 'Favicon URL for browser tab icon',
    },
    {
      key: 'logo_alt',
      value: 'Setaragan Zirak School Logo',
      type: 'brand',
      description: 'Alt text for logo image (accessibility)',
    },
    {
      key: 'show_logo_text',
      value: 'true',
      type: 'brand',
      description: 'Show logo text alongside image (true/false)',
    },
  ];

  for (const setting of logoSettings) {
    await prisma.siteSettings.upsert({
      where: { key: setting.key },
      update: {
        value: setting.value,
        type: setting.type,
        description: setting.description,
      },
      create: setting,
    });
  }

  console.log('✅ Logo settings seeded successfully');
}

seedLogoSettings()
  .catch((e) => {
    console.error('❌ Error seeding logo settings:', e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
