'use client';

import React from 'react';
import {
  Users,
  FileText,
  GraduationCap,
  DollarSign,
  Mail,
  TrendingUp,
  Activity,
} from 'lucide-react';

const AdminDashboard = () => {
  // Mock data - will be replaced with real data from MySQL
  const stats = [
    { name: 'Total Teachers', value: '24', icon: Users, color: 'bg-gradient-to-br from-blue-500 to-blue-600' },
    { name: 'Total Students', value: '156', icon: GraduationCap, color: 'bg-gradient-to-br from-purple-500 to-purple-600' },
    { name: 'News Articles', value: '42', icon: FileText, color: 'bg-gradient-to-br from-blue-600 to-purple-600' },
    { name: 'Donations', value: '$12,450', icon: DollarSign, color: 'bg-gradient-to-br from-purple-600 to-blue-600' },
    { name: 'Pending Contacts', value: '8', icon: Mail, color: 'bg-gradient-to-br from-blue-500 to-blue-600' },
    { name: 'Monthly Growth', value: '+12%', icon: TrendingUp, color: 'bg-gradient-to-br from-purple-500 to-purple-600' },
  ];

  const recentActivities = [
    { type: 'news', action: 'created', description: 'New article published: Science Fair 2025', time: '2 hours ago' },
    { type: 'teacher', action: 'updated', description: 'Teacher profile updated: Ahmad Zaki', time: '4 hours ago' },
    { type: 'contact', action: 'created', description: 'New contact message received', time: '5 hours ago' },
    { type: 'donation', action: 'created', description: 'New donation received: $500', time: '1 day ago' },
  ];

  return (
    <div className="space-y-6">
      {/* Page Header */}
      <div className="border-b border-gray-200 pb-4">
        <h1 className="text-2xl font-bold text-gray-900">Dashboard</h1>
        <p className="text-sm text-gray-600 mt-1">Welcome to the admin panel</p>
      </div>

      {/* Stats Grid */}
      <div className="grid grid-cols-1 gap-6 sm:grid-cols-2 lg:grid-cols-3">
        {stats.map((stat) => {
          const Icon = stat.icon;
          return (
            <div
              key={stat.name}
              className="bg-white rounded-lg shadow-sm border border-gray-200 p-6 hover:shadow-md transition-shadow"
            >
              <div className="flex items-center justify-between">
                <div>
                  <p className="text-sm font-medium text-gray-600">{stat.name}</p>
                  <p className="text-3xl font-bold text-gray-900 mt-2">{stat.value}</p>
                </div>
                <div className={`${stat.color} rounded-full p-3`}>
                  <Icon className="h-6 w-6 text-white" />
                </div>
              </div>
            </div>
          );
        })}
      </div>

      {/* Two Column Layout */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
        {/* Recent Activity */}
        <div className="bg-white rounded-lg shadow-sm border border-gray-200">
          <div className="border-b border-gray-200 px-6 py-4">
            <h2 className="text-lg font-semibold text-gray-900 flex items-center">
              <Activity className="h-5 w-5 mr-2 text-blue-600" />
              Recent Activity
            </h2>
          </div>
          <div className="p-6">
            <div className="space-y-4">
              {recentActivities.map((activity, index) => (
                <div key={index} className="flex items-start space-x-3">
                  <div className="flex-shrink-0">
                    <div className="h-8 w-8 rounded-full bg-gradient-to-br from-blue-100 to-purple-100 flex items-center justify-center">
                      <Activity className="h-4 w-4 text-blue-600" />
                    </div>
                  </div>
                  <div className="flex-1 min-w-0">
                    <p className="text-sm text-gray-900">{activity.description}</p>
                    <p className="text-xs text-gray-500 mt-1">{activity.time}</p>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>

        {/* Quick Actions */}
        <div className="bg-white rounded-lg shadow-sm border border-gray-200">
          <div className="border-b border-gray-200 px-6 py-4">
            <h2 className="text-lg font-semibold text-gray-900">Quick Actions</h2>
          </div>
          <div className="p-6">
            <div className="grid grid-cols-2 gap-4">
              <button className="flex flex-col items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg hover:border-blue-600 hover:bg-blue-50 transition-all hover:shadow-md">
                <FileText className="h-8 w-8 text-blue-600 mb-2" />
                <span className="text-sm font-medium text-gray-900">Add News</span>
              </button>
              <button className="flex flex-col items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg hover:border-purple-600 hover:bg-purple-50 transition-all hover:shadow-md">
                <Users className="h-8 w-8 text-purple-600 mb-2" />
                <span className="text-sm font-medium text-gray-900">Add Teacher</span>
              </button>
              <button className="flex flex-col items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg hover:border-blue-600 hover:bg-blue-50 transition-all hover:shadow-md">
                <GraduationCap className="h-8 w-8 text-blue-600 mb-2" />
                <span className="text-sm font-medium text-gray-900">Add Student</span>
              </button>
              <button className="flex flex-col items-center justify-center p-4 border-2 border-dashed border-gray-300 rounded-lg hover:border-purple-600 hover:bg-purple-50 transition-all hover:shadow-md">
                <Mail className="h-8 w-8 text-purple-600 mb-2" />
                <span className="text-sm font-medium text-gray-900">View Contacts</span>
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default AdminDashboard;
