'use client';

import HeroSlidesSection from "@/components/admin/settings/HeroSlidesSection";
import LogoSettingsSection from "@/components/admin/settings/LogoSettingsSection";
import ContactSettingsSection from "@/components/admin/settings/ContactSettingsSection";
import { Tabs } from "@/components/common/ui/tabs";
import { useState } from "react";
import { Image as ImageIcon, Phone, Sparkles } from "lucide-react";

export default function SiteSettingsPage() {
  const [activeTab, setActiveTab] = useState<'logo' | 'contact' | 'hero-slider'>('logo');

  const tabs = [
    {
      id: 'logo',
      label: 'Logo & Branding',
      icon: <ImageIcon className="w-5 h-5" />
    },
    {
      id: 'contact',
      label: 'Contact Information',
      icon: <Phone className="w-5 h-5" />
    },
    {
      id: 'hero-slider',
      label: 'Hero Slider',
      icon: <Sparkles className="w-5 h-5" />
    }
  ];

  return (
    <div className="min-h-screen bg-gray-50 py-12 px-4 sm:px-6 lg:px-8">
      <div className="max-w-7xl mx-auto">
        {/* Header */}
        <div className="mb-8">
          <h1 className="text-3xl font-bold text-gray-900">Site Settings</h1>
          <p className="mt-2 text-gray-600">Manage website content and appearance</p>
        </div>

        {/* Tabs */}
        <Tabs
          tabs={tabs}
          defaultTab="logo"
          onChange={(tabId) => setActiveTab(tabId as 'logo' | 'contact' | 'hero-slider')}
        >
          {activeTab === 'logo' && <LogoSettingsSection />}
          {activeTab === 'contact' && <ContactSettingsSection />}
          {activeTab === 'hero-slider' && <HeroSlidesSection />}
        </Tabs>
      </div>
    </div>
  );
}
