/**
 * Admin Panel Layout
 * 
 * IMPORTANT: This layout wraps all admin routes.
 * Completely isolated from public site - renders ONLY admin/layout.
 */

import React, { ReactNode } from 'react';
import AppLayout from "@/components/admin/layout";


export const metadata = {
  title: 'Admin Panel | Setaragan Zirak School',
  description: 'School administration and content management',
};

interface LayoutProps {
  children: ReactNode;
}

export default function Layout({ children }: LayoutProps) {
  // Admin layout completely replaces public layout
  return <AppLayout>{children}</AppLayout>;
}
