import { NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';
import { withAdminAuth, createSuccessResponse } from '@/lib/admin/security';

export async function GET() {
  try {
    const auth = await withAdminAuth();
    if (auth.error) {
      return auth.response!;
    }

    const admissions = await prisma.admissionsInquiry.findMany({
      orderBy: { createdAt: 'desc' },
    });

    return createSuccessResponse(admissions, 'Admissions fetched successfully');
  } catch (error) {
    console.error('Error fetching admissions:', error);
    return NextResponse.json(
      { success: false, message: 'Failed to fetch admissions' },
      { status: 500 }
    );
  }
}
