
// ==================== AUTH UTILITIES ====================
import { NextResponse } from 'next/server';
import { auth } from '@/lib/auth';

/**
 * Admin authentication middleware for API routes
 * Returns an object with error status and response if authentication fails
 */
export async function requireAdminAuth(): Promise<{ error: boolean; response?: NextResponse }> {
  try {
    const session = await auth();

    if (!session?.user?.id) {
      return {
        error: true,
        response: NextResponse.json(
          { success: false, message: 'Unauthorized' },
          { status: 401 }
        ),
      };
    }

    // Check if user is admin (adjust based on your auth setup)
    if (session.user.role !== 'admin') {
      return {
        error: true,
        response: NextResponse.json(
          { success: false, message: 'Forbidden - Admin role required' },
          { status: 403 }
        ),
      };
    }

    return { error: false };
  } catch {
    return {
      error: true,
      response: NextResponse.json(
        { success: false, message: 'Authentication error' },
        { status: 401 }
      ),
    };
  }
}