import { NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';
import { withAdminAuth, createSuccessResponse } from '@/lib/admin/security';

export async function GET() {
  try {
    const auth = await withAdminAuth();
    if (auth.error) {
      return auth.response!;
    }

    const contacts = await prisma.contact.findMany({
      orderBy: { createdAt: 'desc' },
    });

    return createSuccessResponse(contacts, 'Contacts fetched successfully');
  } catch (error) {
    console.error('Error fetching contacts:', error);
    return NextResponse.json(
      { success: false, message: 'Failed to fetch contacts' },
      { status: 500 }
    );
  }
}
