import { prisma } from '@/lib/prisma';
import { withAdminAuth, createSuccessResponse, createErrorResponse } from '@/lib/admin/security';

export async function GET() {
  try {
    const auth = await withAdminAuth();
    if (auth.error) return auth.response!;

    const donations = await prisma.donation.findMany({
      orderBy: { createdAt: 'desc' },
    });

    return createSuccessResponse(donations, 'Donations fetched successfully');
  } catch (error) {
    console.error('Error fetching donations:', error);
    return createErrorResponse('Failed to fetch donations', 500);
  }
}
