import { auth } from "@/lib/auth";
import { prisma } from "@/lib/prisma";
import { createSuccessResponse, createErrorResponse } from "@/lib/admin/security";

export async function GET() {
  try {
    // Get session - allows any authenticated user
    const session = await auth();

    if (!session?.user?.id) {
      return createErrorResponse("Unauthorized - Please sign in", 401);
    }

    // Fetch complete user profile from database
    const user = await prisma.adminUser.findUnique({
      where: { id: session.user.id },
      select: {
        id: true,
        name: true,
        email: true,
        role: true,
        avatar: true,
        bio: true,
        phone: true,
        department: true,
        status: true,
        active: true,
        createdAt: true,
        updatedAt: true,
        lastLogin: true,
      },
    });

    if (!user) {
      return createErrorResponse("User not found", 404);
    }

    return createSuccessResponse(user, "User profile retrieved successfully");
  } catch (error) {
    console.error("Get user profile error:", error);
    return createErrorResponse("Failed to retrieve user profile", 500);
  }
}
