import { NextResponse } from 'next/server';
import { generateCsrfToken } from '@/lib/admin/csrf';

/**
 * Generate a CSRF token for client-side forms
 * Used by signin and signup forms to protect against CSRF attacks
 */
export async function GET() {
  try {
    const token = generateCsrfToken();

    return NextResponse.json(
      {
        success: true,
        token,
      },
      {
        status: 200,
        headers: {
          // Allow credentials if cross-origin
          'Access-Control-Allow-Credentials': 'true',
        },
      }
    );
  } catch (error) {
    console.error('CSRF token generation error:', error);
    return NextResponse.json(
      { success: false, message: 'Failed to generate CSRF token' },
      { status: 500 }
    );
  }
}
