import { NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';

// GET /api/hero-slides - Fetch active hero slides for public display
export async function GET() {
  try {
    const slides = await prisma.heroSlide.findMany({
      where: { active: true },
      orderBy: { order: 'asc' },
      select: {
        id: true,
        title: true,
        description: true,
        imageUrl: true,
        alt: true,
        order: true,
      },
    });

    return NextResponse.json({ success: true, data: slides }, { status: 200 });
  } catch (error) {
    console.error('Error fetching hero slides:', error);
    return NextResponse.json(
      { success: false, message: 'Failed to fetch hero slides' },
      { status: 500 }
    );
  }
}
