import { NextRequest, NextResponse } from 'next/server';
import { prisma } from '@/lib/prisma';

// GET /api/site-settings - Public endpoint to fetch site settings
export async function GET(request: NextRequest) {
  try {
    const { searchParams } = new URL(request.url);
    const keys = searchParams.get('keys')?.split(',');

    const settings = keys
      ? await prisma.siteSettings.findMany({
          where: { key: { in: keys } },
          select: { key: true, value: true },
        })
      : await prisma.siteSettings.findMany({
          select: { key: true, value: true },
        });

    // Convert to object format { key: value }
    const settingsObj = settings.reduce((acc, setting) => {
      acc[setting.key] = setting.value;
      return acc;
    }, {} as Record<string, string>);

    return NextResponse.json({ success: true, data: settingsObj }, { status: 200 });
  } catch (error) {
    console.error('Error fetching site settings:', error);
    return NextResponse.json(
      { success: false, message: 'Failed to fetch site settings' },
      { status: 500 }
    );
  }
}
