import { Metadata } from "next";
import {
  HeroSection,
  FacilitiesOverview,
  VirtualTour,
  CallToAction,
} from "@/components/pages/facilities";
import AppLayout from "@/components/common/layout/AppLayout";

export const metadata: Metadata = {
  title: "Facilities - Setaragan Zirak School",
  description:
    "Explore our modern facilities including science laboratory, computer lab, and library designed to enhance student learning and academic excellence.",
};

export default function FacilitiesPage() {
  return (
    <AppLayout>
      <main className="min-h-screen">
        <HeroSection />
        <FacilitiesOverview />
        <VirtualTour />
        <CallToAction />
      </main>
    </AppLayout>
  );
}
