import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import { AppLayout } from "@/components/common/layout";
import NextTopLoader from "nextjs-toploader";
import { SessionProvider } from "next-auth/react";
import { AuthProvider } from "@/context/auth-context";
import { ReactQueryProvider } from "@/providers/react-query-provider";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "Setaragan Zirak School - Empowering Education in Afghanistan",
  description:
    "Quality education for students in Jaghori, Ghazni Province. Dedicated to academic excellence and community development since 1990.",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased bg-white text-gray-900`}
      >
        <SessionProvider>
          <AuthProvider>
            <ReactQueryProvider>
              <NextTopLoader
                color="linear-gradient(to right, #4ade80, #3b82f6, #9333ea)"
                initialPosition={0.08}
                crawlSpeed={200}
                height={3}
                crawl={true}
                showSpinner={true}
                easing="ease"
                speed={200}
                zIndex={99999}
                showForHashAnchor={true}
              />
              {children}
            </ReactQueryProvider>
          </AuthProvider>
        </SessionProvider>
      </body>
    </html>
  );
}
