'use client';

import React from 'react';
import Link from 'next/link';
import { Construction, Home, ArrowLeft } from 'lucide-react';

export default function NotFound() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-primary-50 via-white to-secondary-50 flex items-center justify-center px-4 h-screen">
      <div className="max-w-2xl mx-auto text-center">
        {/* Construction Icon */}
        <div className="relative mb-8">
          <div className="inline-flex items-center justify-center w-32 h-32 bg-gradient-to-br from-primary-100 to-secondary-100 rounded-full shadow-2xl">
            <Construction className="w-16 h-16 text-primary-600 animate-bounce" />
          </div>
          <div className="absolute -top-2 -right-2 w-8 h-8 bg-yellow-400 rounded-full flex items-center justify-center shadow-lg animate-pulse">
            <span className="text-yellow-800 text-xl">⚠️</span>
          </div>
        </div>

        {/* Main Content */}
        <div className="space-y-6">
          <div>
            <h1 className="text-6xl md:text-8xl font-bold text-transparent bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 bg-clip-text mb-4">
              404
            </h1>
            <h2 className="text-3xl md:text-4xl font-bold text-gray-800 mb-2">
              Under Construction
            </h2>
            <p className="text-lg md:text-xl text-gray-600 leading-relaxed max-w-lg mx-auto">
              We&apos;re working hard to bring you something amazing. This page is currently under construction.
            </p>
          </div>

          {/* Progress Indicator */}
          <div className="max-w-md mx-auto">
            <div className="bg-gray-200 rounded-full h-3 shadow-inner">
              <div className="bg-gradient-to-r from-primary-500 to-secondary-500 h-3 rounded-full shadow-sm animate-pulse" style={{ width: '65%' }}></div>
            </div>
            <p className="text-sm text-gray-500 mt-2">Construction Progress: 65%</p>
          </div>

          {/* Action Buttons */}
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center pt-8">
            <Link
              href="/"
              className="group inline-flex items-center bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 text-white px-8 py-4 rounded-xl font-semibold text-lg shadow-xl hover:shadow-2xl transform hover:scale-105 transition-all duration-300 overflow-hidden relative"
            >
              <span className="relative z-10 flex items-center">
                <Home className="w-5 h-5 mr-2 transition-transform duration-300 group-hover:scale-110" />
                Go Home
              </span>
              <div className="absolute inset-0 bg-gradient-to-r from-primary-700 via-primary-600 to-secondary-700 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
            </Link>

            <button
              onClick={() => window.history.back()}
              className="group inline-flex items-center bg-white text-gray-700 border-2 border-gray-300 hover:border-primary-300 px-8 py-4 rounded-xl font-semibold text-lg shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-300 hover:bg-gradient-to-r hover:from-primary-50 hover:to-secondary-50"
            >
              <ArrowLeft className="w-5 h-5 mr-2 transition-transform duration-300 group-hover:-translate-x-1" />
              Go Back
            </button>
          </div>

          {/* School Branding */}
          <div className="pt-12 border-t border-gray-200 mt-12">
            <div className="flex items-center justify-center space-x-3 mb-4">
              <div className="w-10 h-10 bg-gradient-to-br from-primary-600 via-primary-500 to-secondary-600 rounded-lg flex items-center justify-center shadow-lg">
                <span className="text-white font-bold text-sm">SZ</span>
              </div>
              <div>
                <h3 className="font-bold text-xl bg-gradient-to-r from-primary-600 to-secondary-600 bg-clip-text text-transparent">
                  Setaragan Zirak School
                </h3>
              </div>
            </div>
            <p className="text-gray-500 text-sm max-w-md mx-auto">
              Empowering education and building brighter futures for students in Afghanistan.
            </p>
          </div>
        </div>

        {/* Background Decorations */}
        <div className="absolute top-10 left-10 w-20 h-20 bg-primary-200 rounded-full opacity-30 animate-float"></div>
        <div className="absolute top-32 right-16 w-16 h-16 bg-secondary-200 rounded-full opacity-30 animate-float-delay"></div>
        <div className="absolute bottom-20 left-20 w-12 h-12 bg-primary-300 rounded-full opacity-40 animate-float"></div>
        <div className="absolute bottom-32 right-12 w-24 h-24 bg-secondary-200 rounded-full opacity-20 animate-float-delay"></div>
      </div>

      <style jsx>{`
        @keyframes float {
          0%, 100% {
            transform: translateY(0px);
          }
          50% {
            transform: translateY(-20px);
          }
        }
        
        @keyframes float-delay {
          0%, 100% {
            transform: translateY(0px);
          }
          50% {
            transform: translateY(-15px);
          }
        }
        
        .animate-float {
          animation: float 6s ease-in-out infinite;
        }
        
        .animate-float-delay {
          animation: float-delay 8s ease-in-out infinite;
        }
      `}</style>
    </div>
  );
}