import React from "react";
import { Metadata } from "next";
import {
  HeroSection,
  ProgramOverview,
  Features,
  Impact,
  CallToAction,
} from "@/components/pages/online-school";
import AppLayout from "@/components/common/layout/AppLayout";

export const metadata: Metadata = {
  title: "Online School - Setaragan Zirak School",
  description:
    "Empowering women through accessible online education. Join our pioneering initiative dedicated to breaking barriers and fostering educational opportunities.",
};

export default function OnlineSchoolPage() {
  return (
    <AppLayout>
      <div className="min-h-screen">
        <HeroSection />
        <ProgramOverview />
        <Features />
        <Impact />
        <CallToAction />
      </div>
    </AppLayout>
  );
}
