import React from "react";
import { Metadata } from "next";
import {
  CallToAction,
  HeroSection,
  ServicesOverview,
} from "@/components/pages/services";
import AppLayout from "@/components/common/layout/AppLayout";

export const metadata: Metadata = {
  title: "Our Services - Setaragan Zirak School",
  description:
    "Discover our comprehensive educational services designed to nurture holistic development and academic excellence.",
};

export default function ServicesPage() {
  return (
    <AppLayout>
      <div className="min-h-screen">
        <HeroSection />
        <ServicesOverview />
        <CallToAction />
      </div>
    </AppLayout>
  );
}
