import React from "react";
import { Metadata } from "next";
import {
  HeroSection,
  StudentStories,
  Achievements,
  CallToAction,
} from "@/components/pages/students";
import AppLayout from "@/components/common/layout/AppLayout";

export const metadata: Metadata = {
  title: "Our Students - Setaragan Zirak School",
  description:
    "Discover the inspiring stories and achievements of our exceptional students at Setaragan Zirak Private School.",
};

export default function StudentsPage() {
  return (
    <AppLayout>
      <div className="min-h-screen">
        <HeroSection />
        <StudentStories />
        <Achievements />
        <CallToAction />
      </div>
    </AppLayout>
  );
}
