import React from 'react';
import { Metadata } from 'next';
import { HeroSection, TeamMembers, Leadership, CallToAction } from '@/components/pages/team';
import AppLayout from '@/components/common/layout/AppLayout';

export const metadata: Metadata = {
  title: 'Our Team - Setaragan Zirak School',
  description: 'Meet our dedicated faculty and staff members who are committed to providing exceptional education and nurturing student success.',
};

export default function TeamPage() {
  return (
    <AppLayout>
    <main className="min-h-screen">
      <HeroSection />
      <Leadership />
      <TeamMembers />
      <CallToAction />
    </main>
    </AppLayout>
  );
}
