'use client'


import { useState } from 'react'
import Sidebar from './sidebar'
import Header from './header'
import { ToastContainer } from 'react-toastify'




export default function Layout({children}:{children: React.ReactNode}) {
  const [sidebarOpen, setSidebarOpen] = useState(false)
  return (
    <>
      <div className='flex h-screen overflow-x-hidden overflow-y-auto bg-neutral-100'>
        <Sidebar sidebarOpen={ sidebarOpen } setSidebarOpen={setSidebarOpen} />
        <div className="flex flex-col flex-1 h-full lg:pl-64 overflow-x-hidden">
          <div className="flex-1  flex flex-col">
            <Header setSidebarOpen={ setSidebarOpen } />

            <main className="py-10 flex-1 h-full">
              <div className="px-4 sm:px-6 lg:px-8 h-full">{children}</div>
            </main>
          </div>
        </div>
        <ToastContainer
          position="top-right"
          autoClose={5000}
          hideProgressBar={false}
          newestOnTop={false}
          closeButton={true}
          pauseOnHover
          pauseOnFocusLoss
          draggable
          draggablePercent={80}
          limit={3}
        />
      </div>
    </>
  )
}
