"use client";

interface UserManagementTabsProps {
  activeStatus: "pending" | "approved" | "rejected" | "suspended" | "all";
  onStatusChange: (status: "pending" | "approved" | "rejected" | "suspended" | "all") => void;
}

export function UserManagementTabs({ activeStatus, onStatusChange }: UserManagementTabsProps) {
  const tabs = [
    { value: "pending" as const, label: "Pending", color: "yellow" },
    { value: "approved" as const, label: "Approved", color: "green" },
    { value: "rejected" as const, label: "Rejected", color: "red" },
    { value: "suspended" as const, label: "Suspended", color: "orange" },
    { value: "all" as const, label: "All", color: "gray" },
  ];

  return (
    <div className="flex gap-2 border-b border-gray-200">
      {tabs.map((tab) => {
        const isActive = activeStatus === tab.value;
        const colorClass =
          tab.color === "yellow"
            ? isActive
              ? "border-yellow-500 text-yellow-600"
              : "border-transparent text-gray-600 hover:text-gray-900"
            : tab.color === "green"
              ? isActive
                ? "border-green-500 text-green-600"
                : "border-transparent text-gray-600 hover:text-gray-900"
              : tab.color === "red"
                ? isActive
                  ? "border-red-500 text-red-600"
                  : "border-transparent text-gray-600 hover:text-gray-900"
                : tab.color === "orange"
                  ? isActive
                    ? "border-orange-500 text-orange-600"
                    : "border-transparent text-gray-600 hover:text-gray-900"
                  : isActive
                    ? "border-gray-500 text-gray-900"
                    : "border-transparent text-gray-600 hover:text-gray-900";

        return (
          <button
            key={tab.value}
            onClick={() => onStatusChange(tab.value)}
            className={`px-4 py-2 border-b-2 font-medium text-sm transition-colors ${colorClass}`}
          >
            {tab.label}
          </button>
        );
      })}
    </div>
  );
}
