import React from 'react';
import Header from './Header';
import Footer from './Footer';
import ScrollToTop from '../ui/scroll-to-top';

interface AppLayoutProps {
  children: React.ReactNode;
}

const AppLayout: React.FC<AppLayoutProps> = ({ children }) => {
  return (
    <>
    <div id='page-container' className="relative min-h-screen max-h-screen overflow-y-auto overflow-x-hidden flex flex-col">
      <Header />
      <main className="flex-1">
        {children}
      </main>
      <Footer />
      </div>
      <ScrollToTop />
    </>
  );
};

export default AppLayout;
