"use client";

import React from "react";
import Avatar from "./avatar";

// Avatar Showcase Component - For testing and demonstration
export default function AvatarShowcase() {
  const sampleUsers = [
    { name: "John Doe", image: undefined },
    { name: "Jane Smith", image: "/images/sample-avatar.jpg" },
    { name: "Bob Wilson", image: undefined },
    { name: "Alice Johnson", image: undefined },
    { name: "Charlie Brown", image: undefined },
    { name: "Diana Prince", image: undefined },
  ];

  return (
    <div className="p-8 space-y-8">
      <h2 className="text-2xl font-bold mb-6">Avatar Component Showcase</h2>

      {/* Size Variants */}
      <div>
        <h3 className="text-lg font-semibold mb-4">Size Variants</h3>
        <div className="flex items-center gap-4">
          <Avatar name="John Doe" size="xs" />
          <Avatar name="Jane Smith" size="sm" />
          <Avatar name="Bob Wilson" size="md" />
          <Avatar name="Alice Johnson" size="lg" />
          <Avatar name="Charlie Brown" size="xl" />
          <Avatar name="Diana Prince" size="2xl" />
        </div>
      </div>

      {/* Shape Variants */}
      <div>
        <h3 className="text-lg font-semibold mb-4">Shape Variants</h3>
        <div className="flex items-center gap-4">
          <Avatar name="John Doe" variant="circle" size="lg" />
          <Avatar name="Jane Smith" variant="rounded" size="lg" />
          <Avatar name="Bob Wilson" variant="square" size="lg" />
        </div>
      </div>

      {/* With Images vs Initials */}
      <div>
        <h3 className="text-lg font-semibold mb-4">Image vs Initials Fallback</h3>
        <div className="flex items-center gap-4">
          <div className="text-center">
            <Avatar name="John Doe" size="lg" />
            <p className="text-sm text-gray-600 mt-2">No Image (Initials)</p>
          </div>
          <div className="text-center">
            <Avatar
              src="https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=100&h=100&fit=crop&crop=face"
              name="Jane Smith"
              size="lg"
            />
            <p className="text-sm text-gray-600 mt-2">With Image</p>
          </div>
        </div>
      </div>

      {/* Real-world Usage Example */}
      <div>
        <h3 className="text-lg font-semibold mb-4">Real-world Usage (User List)</h3>
        <div className="space-y-3">
          {sampleUsers.map((user, index) => (
            <div key={index} className="flex items-center gap-3 p-3 bg-gray-50 rounded-lg">
              <Avatar
                src={user.image}
                name={user.name}
                size="md"
                alt={`${user.name}'s avatar`}
              />
              <div>
                <p className="font-medium text-gray-900">{user.name}</p>
                <p className="text-sm text-gray-600">Sample user description</p>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
}