import React from "react";
import classNames from "classnames";

interface CardProps extends React.HTMLAttributes<HTMLDivElement> {
  variant?: "default" | "elevated" | "outlined" | "glass";
  padding?: "none" | "sm" | "md" | "lg";
  hover?: boolean;
}

const Card: React.FC<CardProps> = ({ 
  className, 
  children, 
  variant = "default",
  padding = "md",
  hover = true,
  ...props 
}) => {
  const baseClass = "rounded-xl transition-all duration-300";
  
  const variantClasses = {
    default: "bg-white shadow-md border border-gray-100",
    elevated: "bg-white shadow-lg border border-gray-100",
    outlined: "bg-white border-2 border-gray-200 shadow-sm",
    glass: "bg-white/80 backdrop-blur-lg border border-white/20 shadow-lg",
  };

  const paddingClasses = {
    none: "",
    sm: "p-4",
    md: "p-6",
    lg: "p-8",
  };

  const hoverClass = hover ? "hover:shadow-xl hover:-translate-y-1" : "";

  return (
    <div 
      className={classNames(
        baseClass,
        variantClasses[variant],
        paddingClasses[padding],
        hoverClass,
        className
      )} 
      {...props}
    >
      {children}
    </div>
  );
};

export default Card;
