"use client";

import { useState, useEffect } from "react";
import Image, { ImageProps } from "next/image";

interface SafeImageProps extends Omit<ImageProps, "src"> {
  src: string;
  fallbackSvg?: string;
}

export default function SafeImage({
  src,
  alt,
  fallbackSvg,
  ...props
}: SafeImageProps) {
  const defaultFallback = `data:image/svg+xml;base64,${btoa(
    `<svg width="800" height="450" xmlns="http://www.w3.org/2000/svg">
      <rect width="800" height="450" fill="#f3f4f6"/>
      <text x="50%" y="50%" font-family="system-ui" font-size="24"
        fill="#6b7280" text-anchor="middle" dy=".3em">Image not available</text>
    </svg>`
  )}`;

  const [imgSrc, setImgSrc] = useState(src);

  // Update imgSrc when src prop changes (fixes pagination issues)
  useEffect(() => {
    setImgSrc(src);
  }, [src]);

  return (
    <Image
      {...props}
      src={imgSrc || defaultFallback}
      alt={alt}
      onError={() => setImgSrc(fallbackSvg || defaultFallback)}
    />
  );
}
