'use client';

import React, { useState, useEffect } from 'react';
import { ArrowUp } from 'lucide-react';

const ScrollToTop = () => {
  const [isVisible, setIsVisible] = useState(false);
  const [mounted, setMounted] = useState(false);

  useEffect(() => {
    setMounted(true);

    const pageContainer = document.getElementById('page-container');

    // If there's no page container, fall back to window scrolling
    if (!pageContainer) {
      const handleScrollWindow = () => {
        const scrollTop = window.scrollY ?? document.documentElement.scrollTop ?? 0;
        setIsVisible(scrollTop > 200);
      };
      window.addEventListener('scroll', handleScrollWindow, { passive: true });
      handleScrollWindow(); // run once on mount
      return () => window.removeEventListener('scroll', handleScrollWindow);
    }

    const handleScroll = () => {
      const scrollTop = (pageContainer.scrollTop as number) ?? 0;
      setIsVisible(scrollTop > 200);
    };
    pageContainer.addEventListener('scroll', handleScroll, { passive: true });
    handleScroll(); // run once on mount

    return () => pageContainer.removeEventListener('scroll', handleScroll);
  }, []);

  const scrollToTop = () => {
    const pageContainer = document.getElementById('page-container');
    pageContainer?.scrollTo({ top: 0, behavior: 'smooth' });
  };

  const buttonElement = (
    <button
      onClick={scrollToTop}
      title="Scroll to top"
      aria-label="Scroll to top"
      className={`fixed! bottom-6 right-6 w-10 h-10 bg-gradient-to-r from-primary-600 to-secondary-600 hover:from-primary-700 hover:to-secondary-700 text-white rounded-full shadow-lg hover:shadow-xl flex items-center justify-center group transition-all duration-300 ease-in-out focus:outline-none focus:ring-4 focus:ring-primary-200 z-[9999] ${
        isVisible
          ? 'opacity-100 translate-y-0 scale-100 pointer-events-auto'
          : 'opacity-0 translate-y-4 scale-95 pointer-events-none'
      }`}
    >
      <ArrowUp className="w-5 h-5 transition-transform duration-300 group-hover:-translate-y-0.5" />

      {/* Animated background ring */}
      <div className="absolute inset-0 rounded-full bg-gradient-to-r from-primary-400 to-secondary-400 opacity-0 group-hover:opacity-20 transition-opacity duration-300 animate-pulse"></div>

      {/* Subtle border glow */}
      <div className="absolute inset-0 rounded-full ring-2 ring-white/20 group-hover:ring-white/40 transition-all duration-300"></div>
    </button>
  );

  if (!mounted) return null;

  // Return the button directly instead of using a portal
  return buttonElement;
};

export default ScrollToTop;
