'use client';

import React from 'react';
import { cn } from '@/lib/utils';

interface Tab {
  id: string;
  label: string;
  icon?: React.ReactNode;
}

interface TabsProps {
  tabs: Tab[];
  defaultTab: string;
  onChange: (tabId: string) => void;
  children: React.ReactNode;
  className?: string;
}

export function Tabs({ tabs, defaultTab, onChange, children, className }: TabsProps) {
  const [activeTab, setActiveTab] = React.useState(defaultTab);

  const handleTabChange = (tabId: string) => {
    setActiveTab(tabId);
    onChange(tabId);
  };

  return (
    <div className={className}>
      {/* Tab Navigation */}
      <div className="flex gap-2 sm:gap-4 border-b border-gray-200 overflow-x-auto">
        {tabs.map((tab) => (
          <button
            key={tab.id}
            onClick={() => handleTabChange(tab.id)}
            className={cn(
              'px-4 sm:px-6 py-3 sm:py-4 font-medium text-sm sm:text-base whitespace-nowrap transition-all flex items-center gap-2',
              activeTab === tab.id
                ? 'text-primary-600 border-b-2 border-primary-600 -mb-px'
                : 'text-gray-600 border-b-2 border-transparent hover:text-gray-900'
            )}
          >
            {tab.icon && <span className="w-4 h-4 sm:w-5 sm:h-5">{tab.icon}</span>}
            {tab.label}
          </button>
        ))}
      </div>

      {/* Tab Content */}
      <div className="mt-8">{children}</div>
    </div>
  );
}

export default Tabs;
