import React from "react";

interface TypographyProps extends React.HTMLAttributes<HTMLElement> {
  children: React.ReactNode;
  className?: string;
}

// Using standardized Tailwind typography classes
export const H1: React.FC<TypographyProps> = ({ className = "", children, ...props }) => (
  <h1 className={`text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 ${className}`} {...props}>
    {children}
  </h1>
);

export const H2: React.FC<TypographyProps> = ({ className = "", children, ...props }) => (
  <h2 className={`text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 ${className}`} {...props}>
    {children}
  </h2>
);

export const H3: React.FC<TypographyProps> = ({ className = "", children, ...props }) => (
  <h3 className={`text-xl sm:text-2xl md:text-3xl font-bold leading-snug tracking-tight text-gray-900 ${className}`} {...props}>
    {children}
  </h3>
);

export const Text: React.FC<TypographyProps> = ({ className = "", children, ...props }) => (
  <p className={`text-sm sm:text-base md:text-lg leading-relaxed text-gray-600 ${className}`} {...props}>
    {children}
  </p>
);

export default { H1, H2, H3, Text };
