import React from 'react';
import Button from '@/components/common/ui/button';
import { Calendar, MapPin, Phone, Mail, ArrowRight } from 'lucide-react';
import Link from 'next/link';

export function CallToAction() {
  return (
    <section className="py-16 lg:py-20 bg-gradient-to-br from-primary-900 via-primary-800 to-secondary-900 text-white relative overflow-hidden">
      <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 relative">
        <div className="text-center mb-12">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Visit Our Campus
          </h2>
          <p className="text-lg text-primary-100 max-w-2xl mx-auto">
            Experience our modern facilities firsthand. Schedule a visit or contact us for more information.
          </p>
        </div>

        <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-8 lg:p-12 border border-white/20">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
            <div>
              <h3 className="text-2xl font-bold mb-6">Get In Touch</h3>
              <div className="space-y-4">
                <div className="flex items-center gap-3">
                  <Phone className="w-5 h-5 text-primary-100" />
                  <p className="font-semibold">+93 (0) 20 123 4567</p>
                </div>
                
                <div className="flex items-center gap-3">
                  <Mail className="w-5 h-5 text-primary-100" />
                  <p className="font-semibold">info@setaraganzirak.edu.af</p>
                </div>
                
                <div className="flex items-center gap-3">
                  <MapPin className="w-5 h-5 text-primary-100" />
                  <p className="font-semibold">Karte Naw, Kabul, Afghanistan</p>
                </div>

                <div className="flex items-center gap-3">
                  <Calendar className="w-5 h-5 text-primary-100" />
                  <p className="font-semibold">Mon-Fri: 8AM - 5PM</p>
                </div>
              </div>
            </div>

            <div className="bg-white/5 rounded-xl p-6 border border-white/10">
              <h4 className="text-xl font-bold mb-4">Schedule a Visit</h4>
              <form className="space-y-4">
                <input
                  type="text"
                  placeholder="Your Name"
                  className="w-full px-4 py-3 bg-white/10 border border-white/20 rounded-lg text-white placeholder-white/60 focus:outline-none focus:ring-2 focus:ring-white/30"
                />
                <input
                  type="email"
                  placeholder="Email Address"
                  className="w-full px-4 py-3 bg-white/10 border border-white/20 rounded-lg text-white placeholder-white/60 focus:outline-none focus:ring-2 focus:ring-white/30"
                />
                <input
                  type="tel"
                  placeholder="Phone Number"
                  className="w-full px-4 py-3 bg-white/10 border border-white/20 rounded-lg text-white placeholder-white/60 focus:outline-none focus:ring-2 focus:ring-white/30"
                />
                <div>
                  <input
                    type="date"
                    className="w-full px-4 py-3 bg-white/10 border border-white/20 rounded-xl text-white focus:outline-none focus:ring-2 focus:ring-white/30 transition-all duration-300"
                  />
                </div>
                <div>
                  <textarea
                    placeholder="Additional requests or questions..."
                    rows={4}
                    className="w-full px-4 py-3 bg-white/10 border border-white/20 rounded-xl text-white placeholder-white/60 focus:outline-none focus:ring-2 focus:ring-white/30 transition-all duration-300 resize-none"
                  ></textarea>
                </div>
                <Button className="w-full bg-gradient-to-r from-primary-600 to-secondary-600 text-white hover:shadow-lg transition-all duration-300 hover:bg-gradient-to-r hover:from-primary-700 hover:to-secondary-700">
                  Schedule Visit
                </Button>
              </form>
            </div>
          </div>
        </div>

        <div className="text-center mt-12">
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link href="/contact">
              <Button className=" bg-gradient-to-r from-primary-600 to-secondary-600 text-white px-8 py-4 font-semibold hover:shadow-lg transition-all duration-300 hover:bg-gradient-to-r hover:from-primary-700 hover:to-secondary-700">
              Contact Us
              </Button>
            </Link>
            <Link href="#virtual-tour">
              <Button 
              variant="outlined" 
              className="border-white! text-white  hover:text-primary-600! px-8 py-3 group"
              >
              Virtual Tour
              <ArrowRight className="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" />
              </Button>
            </Link>
          </div>
        </div>
      </div>
    </section>
  );
}

export default CallToAction;
