'use client';

import React from 'react';
import Card from '@/components/common/ui/card';
import Button from '@/components/common/ui/button';
import { 
  Beaker, 
  Monitor, 
  BookOpen, 
  Users,
  Clock,
  MapPin,
  ChevronRight
} from 'lucide-react';

export function FacilitiesOverview() {
  const facilities = [
    {
      id: 'science-lab',
      title: 'Science Laboratory',
      description: 'Teaching practical subjects is essential for enhancing academic efficiency. Therefore, by providing laboratory facilities at Setaragan Zirak, we create an environment that enables our students to apply theories in practice.',
      image: '/images/facilities/science-lab.jpg',
      icon: Beaker,
      features: [
        'Advanced microscopes and laboratory equipment',
        'Chemistry and physics experiment stations',
        'Safety equipment and protocols',
        'Hands-on learning environment',
        'Expert supervision and guidance'
      ],
      stats: {
        capacity: '30 Students',
        equipment: '50+ Instruments',
        hours: '8AM - 4PM'
      },
      color: 'from-blue-500 to-blue-600'
    },
    {
      id: 'computer-lab',
      title: 'Computer Lab',
      description: 'The use of computers has brought about a great revolution in study methods. With the Setaragan Zirak Computer Lab, students not only learn the skills of the modern world, but also find new opportunities for creativity and innovation. The space is designed for research, which enhances the motivation for learning.',
      image: '/images/facilities/computer-lab.jpg',
      icon: Monitor,
      features: [
        'Modern desktop computers with latest software',
        'High-speed internet connectivity',
        'Programming and coding platforms',
        'Digital design and multimedia tools',
        'Research and project development space'
      ],
      stats: {
        capacity: '40 Students',
        equipment: '35 Computers',
        hours: '8AM - 6PM'
      },
      color: 'from-green-500 to-green-600'
    },
    {
      id: 'library',
      title: 'Library',
      description: 'The Setaragan Zirak Private School Library is a prime destination for goal attainment due to its rich features. Boasting a diverse array of resources from textbooks to literature, it caters to varied needs. The serene environment fosters focused study, while cultural and educational programs like reading sessions and workshops enhance the learning journey.',
      image: '/images/facilities/library.jpg',
      icon: BookOpen,
      features: [
        'Diverse collection of books and digital resources',
        'Quiet study areas and reading spaces',
        'Cultural and educational programs',
        'Reading sessions and workshops',
        'Research assistance and guidance'
      ],
      stats: {
        capacity: '60 Students',
        equipment: '2000+ Books',
        hours: '8AM - 5PM'
      },
      color: 'from-purple-500 to-purple-600'
    }
  ];

  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 bg-gray-50">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-20">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-6">
            🔬 Our Facilities
          </div>
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 mb-6">
            Best Choices For
            <span className="bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 bg-clip-text text-transparent"> Your Future</span>
          </h2>
          <p className="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed">
            Our school facilities showcase Computer Lab, Science Laboratory, and Library - 
            designed to provide comprehensive learning experiences for all students.
          </p>
        </div>

        <div className="space-y-24">
          {facilities.map((facility, index) => (
            <div key={facility.id} className={`flex flex-col ${index % 2 === 1 ? 'lg:flex-row-reverse' : 'lg:flex-row'} gap-12 items-center`}>
              {/* Image Section */}
              <div className="lg:w-1/2">
                <Card className="overflow-hidden shadow-2xl border-0 bg-white hover:shadow-3xl transition-all duration-500 group">
                  <div className="aspect-[4/3] bg-gradient-to-br from-gray-200 to-gray-300 overflow-hidden relative">
                    <div className={`w-full h-full bg-gradient-to-br ${facility.color} flex items-center justify-center relative`}>
                      <facility.icon className="w-24 h-24 text-white opacity-60" />
                      <div className="absolute inset-0 bg-black/20"></div>
                      <div className="absolute bottom-4 left-4 right-4">
                        <div className="bg-white/10 backdrop-blur-sm rounded-lg p-4">
                          <h3 className="text-white font-bold text-xl mb-2">{facility.title}</h3>
                          <div className="flex gap-4 text-white/80 text-sm">
                            <div className="flex items-center gap-1">
                              <Users className="w-4 h-4" />
                              {facility.stats.capacity}
                            </div>
                            <div className="flex items-center gap-1">
                              <Clock className="w-4 h-4" />
                              {facility.stats.hours}
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </Card>
              </div>

              {/* Content Section */}
              <div className="lg:w-1/2 space-y-8">
                <div>
                  <div className="flex items-center gap-3 mb-4">
                    <div className={`w-12 h-12 bg-gradient-to-r ${facility.color} rounded-full flex items-center justify-center`}>
                      <facility.icon className="w-6 h-6 text-white" />
                    </div>
                    <h3 className="text-2xl md:text-3xl font-bold text-gray-900">{facility.title}</h3>
                  </div>
                  <p className="text-gray-700 text-lg leading-relaxed">
                    {facility.description}
                  </p>
                </div>

                {/* Features */}
                <div>
                  <h4 className="text-xl font-bold text-gray-900 mb-4">Key Features:</h4>
                  <div className="space-y-3">
                    {facility.features.map((feature, featureIndex) => (
                      <div key={featureIndex} className="flex items-start gap-3">
                        <ChevronRight className="w-5 h-5 text-primary-600 mt-0.5 flex-shrink-0" />
                        <span className="text-gray-700">{feature}</span>
                      </div>
                    ))}
                  </div>
                </div>

                {/* Stats */}
                <div className="bg-white p-6 rounded-xl shadow-lg border border-gray-100">
                  <h4 className="font-bold text-gray-900 mb-4">Facility Details:</h4>
                  <div className="grid grid-cols-3 gap-4">
                    <div className="text-center">
                      <Users className="w-6 h-6 text-primary-600 mx-auto mb-2" />
                      <p className="text-sm text-gray-600">Capacity</p>
                      <p className="font-bold text-gray-900">{facility.stats.capacity}</p>
                    </div>
                    <div className="text-center">
                      <MapPin className="w-6 h-6 text-primary-600 mx-auto mb-2" />
                      <p className="text-sm text-gray-600">Equipment</p>
                      <p className="font-bold text-gray-900">{facility.stats.equipment}</p>
                    </div>
                    <div className="text-center">
                      <Clock className="w-6 h-6 text-primary-600 mx-auto mb-2" />
                      <p className="text-sm text-gray-600">Hours</p>
                      <p className="font-bold text-gray-900">{facility.stats.hours}</p>
                    </div>
                  </div>
                </div>

                <Button 
                  onClick={() => {
                    const virtualTourSection = document.getElementById('virtual-tour');
                    if (virtualTourSection) {
                      virtualTourSection.scrollIntoView({ behavior: 'smooth' });
                    }
                  }}
                  className="bg-gradient-to-r from-primary-600 to-secondary-600 text-white px-8 py-4 font-semibold hover:shadow-lg transition-all duration-300"
                >
                  Explore {facility.title}
                </Button>
              </div>
            </div>
          ))}
        </div>

        {/* Overall Stats */}
        <div className="mt-20 bg-gradient-to-r from-primary-600 to-secondary-600 text-white p-12 rounded-3xl shadow-2xl">
          <div className="text-center mb-12">
            <h3 className="text-2xl md:text-3xl font-bold mb-4">
              Facilities by the Numbers
            </h3>
            <p className="text-primary-100 text-lg max-w-2xl mx-auto">
              Our comprehensive facilities serve hundreds of students daily, providing 
              exceptional learning opportunities across all disciplines.
            </p>
          </div>
          
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold mb-2">3</div>
              <p className="text-primary-100">Major Facilities</p>
            </div>
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold mb-2">130+</div>
              <p className="text-primary-100">Student Capacity</p>
            </div>
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold mb-2">85+</div>
              <p className="text-primary-100">Equipment & Resources</p>
            </div>
            <div className="text-center">
              <div className="text-3xl md:text-4xl font-bold mb-2">10+</div>
              <p className="text-primary-100">Operating Hours Daily</p>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

export default FacilitiesOverview;
