'use client';

import Link from 'next/link';
import { Users } from 'lucide-react';
import { useLeadership } from '@/hooks/useLeadership';

export function DynamicLeadership() {
  const { data: leadership, isLoading, error } = useLeadership();

  // Show only first 4 members, sorted by order
  const displayLeaders = leadership?.slice(0, 4) ?? [];

  if (error) {
    return (
      <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 relative overflow-hidden bg-gradient-to-br from-gray-50 via-white to-secondary-50/30">
        <div className="relative z-10 max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center">
            <p className="text-red-600">Failed to load leadership team</p>
          </div>
        </div>
      </section>
    );
  }

  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 relative overflow-hidden bg-gradient-to-br from-gray-50 via-white to-secondary-50/30">
      <div className="hidden md:block absolute top-10 sm:top-20 left-10 sm:left-20 w-32 sm:w-64 h-32 sm:h-64 bg-primary-400/10 rounded-full blur-2xl md:blur-3xl" />
      <div className="hidden md:block absolute bottom-10 sm:bottom-20 right-10 sm:right-20 w-40 sm:w-80 h-40 sm:h-80 bg-secondary-400/10 rounded-full blur-2xl md:blur-3xl" />

      <div className="relative z-10 max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-8 sm:mb-12 lg:mb-16">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-3 sm:px-4 py-1.5 sm:py-2 rounded-full font-semibold text-xs sm:text-sm uppercase tracking-wider mb-4 sm:mb-6">
            <Users className="w-3 sm:w-4 h-3 sm:h-4" />
            Leadership Team
          </div>
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-4 sm:mb-6">
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-gray-900 via-primary-600 to-secondary-600">
              Meet Our Core Team Members
            </span>
          </h2>
          <p className="text-base sm:text-lg lg:text-xl text-gray-600 max-w-3xl mx-auto px-4">
            Dedicated professionals committed to educational excellence and
            student success
          </p>
        </div>

        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6 md:gap-8 mb-8 sm:mb-12">
          {isLoading
            ? // Loading skeletons
              Array.from({ length: 4 }).map((_, index) => (
                <div
                  key={`skeleton-${index}`}
                  className="bg-white rounded-xl sm:rounded-2xl md:rounded-3xl p-4 sm:p-6 md:p-8 shadow-lg"
                >
                  <div className="mb-4 sm:mb-6">
                    <div className="w-16 sm:w-20 md:w-24 h-16 sm:h-20 md:h-24 mx-auto bg-gray-200 rounded-full animate-pulse" />
                  </div>
                  <div className="h-4 w-3/4 mx-auto mb-2 bg-gray-200 rounded animate-pulse" />
                  <div className="h-3 w-1/2 mx-auto mb-4 bg-gray-200 rounded animate-pulse" />
                  <div className="space-y-2">
                    <div className="h-3 w-full bg-gray-200 rounded animate-pulse" />
                    <div className="h-3 w-5/6 mx-auto bg-gray-200 rounded animate-pulse" />
                  </div>
                </div>
              ))
            : // Actual content
              displayLeaders.map((member) => (
                <div
                  key={member.id}
                  className="group bg-white rounded-xl sm:rounded-2xl md:rounded-3xl p-4 sm:p-6 md:p-8 shadow-lg hover:shadow-xl transition-shadow duration-200"
                >
                  <div className="relative mb-4 sm:mb-6">
                    <div className="w-16 sm:w-20 md:w-24 h-16 sm:h-20 md:h-24 mx-auto bg-gradient-to-br from-primary-400 to-secondary-500 rounded-full flex items-center justify-center text-white text-sm sm:text-lg md:text-2xl font-bold">
                      {member.name
                        .split(' ')
                        .map((n) => n[0])
                        .join('')}
                    </div>
                  </div>
                  <h3 className="text-base sm:text-lg md:text-xl font-bold text-gray-900 mb-1 sm:mb-2 text-center">
                    {member.name}
                  </h3>
                  <p className="text-primary-600 font-semibold text-center mb-2 sm:mb-3 md:mb-4 text-xs sm:text-sm md:text-base">
                    {member.position}
                  </p>
                  <p className="text-gray-600 text-xs sm:text-sm leading-relaxed text-center">
                    {member.shortDescription}
                  </p>
                </div>
              ))}
        </div>

        <div className="text-center">
          <Link
            href="/team"
            className="inline-flex items-center gap-2 sm:gap-3 bg-gradient-to-r from-primary-500 to-secondary-500 hover:from-primary-600 hover:to-secondary-600 text-white px-4 sm:px-6 md:px-8 py-2.5 sm:py-3 md:py-4 rounded-lg sm:rounded-xl md:rounded-2xl font-bold text-sm sm:text-base md:text-lg transition-colors duration-200 shadow-lg"
          >
            <span>Read More About Core Team Members</span>
            <Users className="w-3 sm:w-4 md:w-5 h-3 sm:h-4 md:h-5" />
          </Link>
        </div>
      </div>
    </section>
  );
}

