'use client'
import { mockNewsData, NewsArticle } from '@/lib/mockNewsData'
import { ArrowRight, Calendar } from 'lucide-react'
import Link from 'next/link'
import { useState } from 'react'
import { ArticleCard } from '../news/NewsPage'


interface LatestNewsProps {
  title?: string
  subtitle?: string
  maxPosts?: number
}

export default function LatestNews({ 
  title = "Latest News & Updates",
  subtitle = "Stay informed about school events, achievements, and announcements",
  maxPosts = 6
}: LatestNewsProps) {
  const [posts, setPosts] = useState<NewsArticle[]>(mockNewsData)
  const [loading, setLoading] = useState(false)
  const [error, setError] = useState<string | null>(null)


 

  if (loading) {
    return (
      <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 relative overflow-hidden bg-gradient-to-br from-gray-50 via-white to-secondary-50/30">
        <div className="relative z-10 max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full font-semibold text-sm uppercase tracking-wider mb-6">
              <Calendar className="w-4 h-4" />
              Latest News
            </div>
            <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold tracking-tight leading-tight text-gray-900 mb-6">
              <span className="text-transparent bg-clip-text bg-gradient-to-r from-gray-900 via-primary-600 to-secondary-600">
                {title}
              </span>
            </h2>
            <p className="text-lg text-gray-600 max-w-3xl mx-auto">
              {subtitle}
            </p>
          </div>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            {[...Array(maxPosts)].map((_, i) => (
              <div key={i} className="bg-white rounded-3xl overflow-hidden shadow-lg animate-pulse">
                <div className="aspect-[4/3] bg-gray-300" />
                <div className="p-6">
                  <div className="h-4 bg-gray-300 rounded mb-4" />
                  <div className="h-6 bg-gray-300 rounded mb-3" />
                  <div className="space-y-2">
                    <div className="h-3 bg-gray-300 rounded" />
                    <div className="h-3 bg-gray-300 rounded w-3/4" />
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>
    )
  }

  if (error) {
    return (
      <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 relative overflow-hidden bg-gradient-to-br from-gray-50 via-white to-secondary-50/30">
        <div className="absolute top-20 left-20 w-64 h-64 bg-primary-400/10 rounded-full blur-3xl" />
        <div className="absolute bottom-20 right-20 w-80 h-80 bg-secondary-400/10 rounded-full blur-3xl" />
        
        <div className="relative z-10 max-w-8xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
          <div className="inline-flex items-center gap-2 bg-orange-100 text-orange-700 px-4 py-2 rounded-full font-semibold text-sm uppercase tracking-wider mb-6">
            <Calendar className="w-4 h-4" />
            News Temporarily Unavailable
          </div>
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold tracking-tight leading-tight text-gray-900 mb-6">
            <span className="bg-gradient-to-r from-gray-900 via-primary-600 to-secondary-600 bg-clip-text text-transparent">
              Stay Connected
            </span>
          </h2>
          <p className="text-lg text-gray-600 mb-8 max-w-2xl mx-auto">
            Our news feed is temporarily unavailable. Please visit our dedicated news page 
            or check back later for the latest school updates and announcements.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link
              href="/news"
              className="inline-flex items-center gap-2 bg-primary-600 hover:bg-primary-700 text-white px-8 py-4 rounded-xl font-semibold transition-all duration-200 shadow-lg hover:shadow-xl"
            >
              <Calendar className="w-5 h-5" />
              Visit News Page
            </Link>
            <Link
              href="/contact"
              className="inline-flex items-center gap-2 border-2 border-primary-300 text-primary-600 px-8 py-4 rounded-xl font-semibold hover:bg-primary-50 hover:border-primary-400 transition-all duration-200"
            >
              Contact Us
              <ArrowRight className="w-5 h-5" />
            </Link>
          </div>
        </div>
      </section>
    )
  }

  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 relative overflow-hidden bg-gradient-to-br from-gray-50 via-white to-secondary-50/30">
      <div className="absolute top-20 left-20 w-64 h-64 bg-primary-400/10 rounded-full blur-3xl" />
      <div className="absolute bottom-20 right-20 w-80 h-80 bg-secondary-400/10 rounded-full blur-3xl" />
      
      <div className="relative z-10 max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-xs sm:text-sm font-semibold tracking-wide uppercase mb-6">
            <Calendar className="w-4 h-4" />
            Latest News
          </div>
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold tracking-tight leading-tight text-gray-900 mb-6">
            <span className="bg-gradient-to-r from-gray-900 via-primary-600 to-secondary-600 bg-clip-text text-transparent">
              {title}
            </span>
          </h2>
          <p className="text-base sm:text-lg md:text-xl leading-relaxed text-gray-600 max-w-3xl mx-auto">
            {subtitle}
          </p>
        </div>

        {posts.length > 0 ? (
          <>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-12">
              {posts.slice(0, 4).map((post, index) => {
                // const isLarge = index === 0 && posts.length > 2

                return (<ArticleCard key={post.id} article={post}  />)
              })}
            </div>

            <div className="text-center">
              <Link 
                href="/news"
                target="_blank"
                rel="noopener noreferrer"
                className="inline-flex items-center gap-3 bg-gradient-to-r from-primary-500 to-secondary-500 hover:from-primary-600 hover:to-secondary-600 text-white px-8 py-4 rounded-2xl font-bold text-lg transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105"
              >
                <span>View All News</span>
                <ArrowRight className="w-5 h-5" />
              </Link>
            </div>
          </>
        ) : (
          <div className="text-center py-12">
            <p className="text-gray-600 text-lg">No recent posts available.</p>
          </div>
        )}
      </div>
    </section>
  )
}
