"use client";

import NewsletterForm from "@/components/common/forms/NewsletterForm";
import Card from "@/components/common/ui/card";
import {
  Award,
  Bell,
  Calendar,
  CheckCircle,
  Users
} from "lucide-react";
import { useState } from "react";

export default function NewsletterSignup() {
  const [email, setEmail] = useState("");
  const [isSubscribed, setIsSubscribed] = useState(false);
  const [isLoading, setIsLoading] = useState(false);

  if (isSubscribed) {
    return (
      <section className="py-16 bg-gradient-to-br from-green-50 to-primary-50">
        <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="max-w-2xl mx-auto text-center">
            <div className="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
              <CheckCircle className="w-8 h-8 text-green-600" />
            </div>
            <h3 className="text-2xl font-bold text-gray-900 mb-4">
              Welcome to Our Newsletter!
            </h3>
            <p className="text-lg text-gray-600 mb-6">
              Thank you for subscribing. You&apos;ll receive the latest school
              news, updates, and important announcements directly in your inbox.
            </p>
            <button
              onClick={() => setIsSubscribed(false)}
              className="text-primary-600 hover:text-primary-700 font-medium"
            >
              Subscribe another email
            </button>
          </div>
        </div>
      </section>
    );
  }

  return (
    <section className="py-16 bg-gradient-to-br from-primary-50 via-white to-secondary-50">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="max-w-6xl mx-auto">
          <Card className="p-8 lg:p-12 bg-white/80 backdrop-blur-sm border-0 shadow-xl">
            <div className="grid lg:grid-cols-2 gap-8 items-center">
              {/* Content */}
              <div>
                <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-6">
                  <Bell className="w-4 h-4" />
                  Stay Updated
                </div>

                <h3 className="text-2xl sm:text-3xl font-bold text-gray-900 mb-4">
                  Never Miss Important
                  <span className="bg-gradient-to-r from-primary-600 to-secondary-600 bg-clip-text text-transparent">
                    {" "}
                    School News
                  </span>
                </h3>

                <p className="text-lg text-gray-600 mb-6">
                  Subscribe to our newsletter and get the latest updates about
                  school events, academic achievements, important announcements,
                  and educational insights delivered directly to your inbox.
                </p>

                {/* Benefits */}
                <div className="space-y-4 mb-8">
                  <div className="flex items-center gap-3">
                    <div className="w-8 h-8 bg-primary-100 rounded-full flex items-center justify-center">
                      <Calendar className="w-4 h-4 text-primary-600" />
                    </div>
                    <span className="text-gray-700">
                      Weekly school updates and event reminders
                    </span>
                  </div>
                  <div className="flex items-center gap-3">
                    <div className="w-8 h-8 bg-secondary-100 rounded-full flex items-center justify-center">
                      <Award className="w-4 h-4 text-secondary-600" />
                    </div>
                    <span className="text-gray-700">
                      Student achievements and success stories
                    </span>
                  </div>
                  <div className="flex items-center gap-3">
                    <div className="w-8 h-8 bg-green-100 rounded-full flex items-center justify-center">
                      <Users className="w-4 h-4 text-green-600" />
                    </div>
                    <span className="text-gray-700">
                      Community news and parent resources
                    </span>
                  </div>
                </div>
              </div>

              {/* Form */}
              <div>
                <NewsletterForm setIsSubscribed={setIsSubscribed} />
                <p className="text-sm text-gray-500 mt-4 text-center">
                  We respect your privacy. Unsubscribe at any time.
                </p>
              </div>
            </div>
          </Card>
        </div>
      </div>
    </section>
  );
}
