import React from 'react';

export function CallToAction() {
  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 bg-gradient-to-br from-gray-50 via-white to-primary-50/30">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-8">
            🚀 Take Action Today
          </div>
          
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 mb-8">
            Your Educational Journey
            <span className="bg-gradient-to-r from-primary-600 to-secondary-600 bg-clip-text text-transparent"> Starts Here</span>
          </h2>
          
          <p className="text-lg text-gray-600 mb-12 leading-relaxed max-w-3xl mx-auto">
            Take the first step towards transforming your life through education. Join our community of empowered women 
            and unlock your potential with Setaragan Zirak Online School.
          </p>

          <div className="flex flex-col sm:flex-row gap-6 justify-center mb-20">
            <button className="bg-gradient-to-r from-primary-600 to-secondary-600 text-white px-8 py-4 rounded-xl font-semibold text-base hover:from-primary-500 hover:to-secondary-500 transition-all duration-300 shadow-2xl transform hover:-translate-y-1">
              Apply for Admission
            </button>
            <button className="border-2 border-primary-300! text-primary-600 px-8 py-4 rounded-xl font-semibold text-base hover:bg-primary-50 hover:border-primary-400! transition-all duration-300">
              Schedule Consultation
            </button>
          </div>
        </div>

        {/* Contact Methods */}
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
          <div className="bg-white p-8 rounded-2xl shadow-xl border border-gray-100 text-center hover:shadow-2xl transition-all duration-300 hover:-translate-y-2">
            <div className="w-16 h-16 bg-gradient-to-r from-primary-500 to-primary-600 rounded-full flex items-center justify-center mx-auto mb-6">
              <span className="text-2xl text-white">📧</span>
            </div>
            <h3 className="text-xl font-bold text-gray-900 mb-4">Email Us</h3>
            <p className="text-gray-600 mb-4">Get detailed information about our programs</p>
            <a 
              href="mailto:paeyndah@gmail.com" 
              className="text-primary-600 font-semibold hover:underline"
            >
              paeyndah@gmail.com
            </a>
          </div>

          <div className="bg-white p-8 rounded-2xl shadow-xl border border-gray-100 text-center hover:shadow-2xl transition-all duration-300 hover:-translate-y-2">
            <div className="w-16 h-16 bg-gradient-to-r from-secondary-500 to-secondary-600 rounded-full flex items-center justify-center mx-auto mb-6">
              <span className="text-2xl text-white">📱</span>
            </div>
            <h3 className="text-xl font-bold text-gray-900 mb-4">WhatsApp</h3>
            <p className="text-gray-600 mb-4">Connect with us instantly</p>
            <a 
              href="https://wa.me/93785675793" 
              className="text-primary-600 font-semibold hover:underline"
              target="_blank"
              rel="noopener noreferrer"
            >
              +93 785 675 793
            </a>
          </div>

          <div className="bg-white p-8 rounded-2xl shadow-xl border border-gray-100 text-center hover:shadow-2xl transition-all duration-300 hover:-translate-y-2">
            <div className="w-16 h-16 bg-gradient-to-r from-primary-600 to-secondary-600 rounded-full flex items-center justify-center mx-auto mb-6">
              <span className="text-2xl text-white">🌐</span>
            </div>
            <h3 className="text-xl font-bold text-gray-900 mb-4">Follow Us</h3>
            <p className="text-gray-600 mb-4">Stay updated with our latest news</p>
            <a 
              href="https://www.facebook.com/profile.php?id=61574760518282" 
              className="text-primary-600 font-semibold hover:underline"
              target="_blank"
              rel="noopener noreferrer"
            >
              Facebook Page
            </a>
          </div>
        </div>

        {/* Final Message */}
        <div className="bg-gradient-to-r from-primary-600 to-secondary-600 text-white p-12 rounded-3xl shadow-2xl text-center">
          <h3 className="text-2xl md:text-3xl font-bold mb-6">
            Together, We Build a Brighter Future
          </h3>
          <p className="text-primary-100 text-lg max-w-2xl mx-auto leading-relaxed">
            Education is the foundation of empowerment. Join us in creating opportunities, 
            breaking barriers, and building a better tomorrow for women in Afghanistan.
          </p>
        </div>
      </div>
    </section>
  );
}

export default CallToAction;
