import React from 'react';
import Card from '@/components/common/ui/card';
import { BookOpen, Users, Monitor, Globe, Clock, Award } from 'lucide-react';

export function Features() {
  const features = [
    {
      icon: BookOpen,
      title: "Comprehensive Curriculum",
      description: "Diverse subjects including language, mathematics, sciences, and vocational training designed for real-world application.",
      color: "from-primary-500 to-primary-600"
    },
    {
      icon: Monitor,
      title: "Flexible Online Learning",
      description: "Accessible education platform allowing students to learn at their own pace from the safety of their homes.",
      color: "from-secondary-500 to-secondary-600"
    },
    {
      icon: Users,
      title: "Expert Instructors",
      description: "Dedicated and experienced teachers committed to providing quality education and personalized support.",
      color: "from-primary-600 to-secondary-600"
    },
    {
      icon: Globe,
      title: "Cultural Sensitivity",
      description: "Programs designed with deep respect for cultural values while promoting educational advancement.",
      color: "from-secondary-600 to-primary-600"
    },
    {
      icon: Clock,
      title: "Flexible Scheduling",
      description: "Classes scheduled to accommodate various life circumstances and family responsibilities.",
      color: "from-primary-500 to-secondary-500"
    },
    {
      icon: Award,
      title: "Certification Programs",
      description: "Recognized certificates and credentials that open doors to future educational and career opportunities.",
      color: "from-secondary-500 to-primary-500"
    }
  ];

  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 bg-white">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-20">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-6">
            ✨ Program Features
          </div>
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 mb-6">
            Why Choose Our
            <span className="bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 bg-clip-text text-transparent"> Online School</span>
          </h2>
          <p className="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed">
            Our online school offers innovative and accessible education designed specifically to meet the unique needs 
            of women in Afghanistan, providing hope and opportunities for a brighter future.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {features.map((feature, index) => (
            <Card key={index} className="p-8 hover:shadow-2xl transition-all duration-500 hover:-translate-y-2 bg-gradient-to-br from-white to-gray-50/50 border-0 group">
              <div className='flex flex-col items-center justify-center'>
                <div className={`w-16 h-16 bg-gradient-to-r ${feature.color} rounded-xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300 shadow-lg`}>
                  <feature.icon className="w-8 h-8 text-white" />
                </div>
                
                <h3 className="text-xl font-bold text-gray-900 mb-4 group-hover:text-primary-600 transition-colors duration-300">
                  {feature.title}
                </h3>
                
              </div>
              <p className="text-gray-600 leading-relaxed">
                {feature.description}
              </p>
            </Card>
          ))}
        </div>

        {/* Bottom CTA Section */}
        <div className="mt-20 bg-gradient-to-r from-primary-600 to-secondary-600 text-white p-12 rounded-3xl shadow-2xl text-center">
          <h3 className="text-2xl md:text-3xl font-bold mb-6">
            Ready to Begin Your Educational Journey?
          </h3>
          <p className="text-primary-100 text-lg mb-8 max-w-2xl mx-auto">
            Join hundreds of women who are already transforming their lives through education. 
            Take the first step towards a brighter future today.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button className="bg-white text-primary-600 px-8 py-4 rounded-xl font-semibold hover:bg-gray-50 transition-colors duration-300 shadow-lg">
              Get Started Now
            </button>
            <button className="border-2 border-white text-white px-8 py-4 rounded-xl font-semibold hover:bg-white hover:text-primary-600 transition-colors duration-300">
              Contact Admissions
            </button>
          </div>
        </div>
      </div>
    </section>
  );
}

export default Features;
