import React from 'react';
import Card from '@/components/common/ui/card';

export function Impact() {
  const impactStats = [
    {
      number: "500+",
      label: "Women Enrolled",
      description: "Active students pursuing their educational dreams"
    },
    {
      number: "15+",
      label: "Subject Areas",
      description: "Comprehensive curriculum covering diverse fields"
    },
    {
      number: "95%",
      label: "Completion Rate",
      description: "Students successfully completing their courses"
    },
    {
      number: "300+",
      label: "Certificates Awarded",
      description: "Recognizing academic achievements and progress"
    }
  ];

  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 bg-gradient-to-br from-primary-50 via-white to-secondary-50">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-20">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-6">
            📈 Our Impact
          </div>
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 mb-6">
            Transforming Lives Through
            <span className="bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 bg-clip-text text-transparent"> Education</span>
          </h2>
          <p className="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed">
            Our online school has become a catalyst for change, empowering women across Afghanistan 
            to pursue their educational goals and build brighter futures for themselves and their communities.
          </p>
        </div>

        {/* Impact Statistics */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-20">
          {impactStats.map((stat, index) => (
            <Card key={index} className="p-8 text-center hover:shadow-xl transition-all duration-300 hover:-translate-y-2 bg-gradient-to-br from-white to-primary-50/30 border-0">
              <div className="text-3xl md:text-4xl font-bold bg-gradient-to-r from-primary-600 to-secondary-600 bg-clip-text text-transparent mb-4">
                {stat.number}
              </div>
              <h3 className="text-lg font-semibold text-gray-900 mb-2">
                {stat.label}
              </h3>
              <p className="text-gray-600 text-sm">
                {stat.description}
              </p>
            </Card>
          ))}
        </div>

        {/* Testimonial Section */}
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
          <div className="space-y-8">
            <Card className="p-8 bg-gradient-to-br from-white via-white to-primary-50/30 shadow-2xl border-0">
              <div className="flex items-start space-x-4">
                <div className="w-12 h-12 bg-gradient-to-br from-primary-500 to-secondary-500 rounded-full flex items-center justify-center flex-shrink-0">
                  <span className="text-white font-bold text-lg">S</span>
                </div>
                <div>
                  <blockquote className="text-gray-700 italic mb-4">
                    &ldquo;This online school gave me hope when I thought my educational journey was over. 
                    The teachers are supportive, and the community of women learners is incredibly inspiring.&rdquo;
                  </blockquote>
                  <div>
                    <p className="font-semibold text-gray-900">Sarah Ahmad</p>
                    <p className="text-gray-600 text-sm">Online School Graduate</p>
                  </div>
                </div>
              </div>
            </Card>

            <Card className="p-8 bg-gradient-to-br from-white via-white to-secondary-50/30 shadow-2xl border-0">
              <div className="flex items-start space-x-4">
                <div className="w-12 h-12 bg-gradient-to-br from-secondary-500 to-primary-500 rounded-full flex items-center justify-center flex-shrink-0">
                  <span className="text-white font-bold text-lg">F</span>
                </div>
                <div>
                  <blockquote className="text-gray-700 italic mb-4">
                    &ldquo;The flexible schedule allowed me to balance my family responsibilities while pursuing my education. 
                    I now have the skills and confidence to support my family better.&rdquo;
                  </blockquote>
                  <div>
                    <p className="font-semibold text-gray-900">Fatima Noori</p>
                    <p className="text-gray-600 text-sm">Current Student</p>
                  </div>
                </div>
              </div>
            </Card>
          </div>

          <div className="space-y-8">
            <div className="bg-gradient-to-br from-primary-500 to-secondary-600 text-white p-8 rounded-3xl shadow-2xl">
              <h3 className="text-2xl md:text-3xl font-bold mb-6">
                Join Us in Celebrating Resilience
              </h3>
              <p className="text-primary-100 leading-relaxed mb-6">
                Join us in celebrating the resilience and determination of Afghan women as they strive for education and equality. 
                Together, we can make a difference in their lives and contribute to a brighter future for Afghanistan.
              </p>
              <div className="space-y-4">
                <div className="flex items-center text-primary-100">
                  <span className="w-2 h-2 bg-white rounded-full mr-3"></span>
                  Breaking educational barriers
                </div>
                <div className="flex items-center text-primary-100">
                  <span className="w-2 h-2 bg-white rounded-full mr-3"></span>
                  Building supportive communities
                </div>
                <div className="flex items-center text-primary-100">
                  <span className="w-2 h-2 bg-white rounded-full mr-3"></span>
                  Empowering future leaders
                </div>
              </div>
            </div>

            <div className="bg-white p-8 rounded-3xl shadow-xl border border-gray-100">
              <h3 className="text-xl font-bold text-gray-900 mb-4">Contact Information</h3>
              <div className="space-y-3 text-gray-600">
                <div className="flex items-center">
                  <span className="font-medium mr-2">Email:</span>
                  <a href="mailto:paeyndah@gmail.com" className="text-primary-600 hover:underline">
                    paeyndah@gmail.com
                  </a>
                </div>
                <div className="flex items-center">
                  <span className="font-medium mr-2">Phone:</span>
                  <a href="tel:+93785675793" className="text-primary-600 hover:underline">
                    +93 785 675 793
                  </a>
                </div>
                <div className="flex items-center">
                  <span className="font-medium mr-2">WhatsApp:</span>
                  <a href="https://wa.me/93785675793" className="text-primary-600 hover:underline">
                    +93 785 675 793
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

export default Impact;
