import React from 'react';
import Card from '@/components/common/ui/card';
import Badge from '@/components/common/ui/badge';

export function ProgramOverview() {
  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 bg-gradient-to-br from-gray-50 via-white to-primary-50/30">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-20">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-6">
            📚 Our Mission
          </div>
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 mb-6">
            Learning Begins
            <span className="bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 bg-clip-text text-transparent"> With Us</span>
          </h2>
          <p className="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed">
            Setaragan Zirak Online School is a pioneering educational initiative dedicated to empowering women in Afghanistan through accessible online learning.
          </p>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center mb-20">
          <div className="space-y-8">
            <div className="bg-gradient-to-br from-primary-500 to-secondary-600 text-white p-8 rounded-3xl shadow-2xl">
              <h3 className="text-2xl font-bold mb-4">Our Vision</h3>
              <p className="text-primary-100 leading-relaxed">
                In a country where educational opportunities for women are often limited, this school serves as a beacon of hope, 
                providing a safe and supportive environment for women to pursue their academic goals.
              </p>
            </div>

            <div className="bg-white p-8 rounded-3xl shadow-xl border border-gray-100">
              <h3 className="text-2xl font-bold text-gray-900 mb-4">Breaking Barriers</h3>
              <p className="text-gray-600 leading-relaxed">
                Our mission is to break down barriers to education, offering classes in various subjects, including language, 
                mathematics, and vocational training that are crucial for personal and professional development.
              </p>
            </div>
          </div>

          <div className="relative">
            <Card className="p-8 bg-gradient-to-br from-white via-white to-primary-50/30 shadow-2xl border-0">
              <div className="text-center">
                <div className="w-20 h-20 bg-gradient-to-br from-primary-500 to-secondary-500 rounded-full flex items-center justify-center mx-auto mb-6 shadow-lg">
                  <span className="text-3xl text-white">💡</span>
                </div>
                <blockquote className="text-xl text-gray-700 italic leading-relaxed mb-6">
                  &ldquo;We aim at inspiring our students to dream more, learn more, do more, and become more in their respective journeys of life.&rdquo;
                </blockquote>
                <div className="space-y-2">
                  <p className="font-semibold text-gray-900">Qudsia Sharifi</p>
                  <Badge variant="outline" className="border-primary-300 text-primary-700 bg-primary-50">
                    Headmaster
                  </Badge>
                </div>
              </div>
            </Card>
          </div>
        </div>

        {/* Key Features */}
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          <Card className="p-8 text-center hover:shadow-xl transition-all duration-300 hover:-translate-y-2 bg-gradient-to-br from-white to-primary-50/30 border-0">
            <div className="w-16 h-16 bg-gradient-to-br from-primary-500 to-primary-600 rounded-full flex items-center justify-center mx-auto mb-6 shadow-lg">
              <span className="text-2xl text-white">🌟</span>
            </div>
            <h3 className="text-xl font-bold text-gray-900 mb-4">Innovative Teaching</h3>
            <p className="text-gray-600 leading-relaxed">
              Through innovative teaching methods and a comprehensive curriculum, we enable women to gain knowledge and skills.
            </p>
          </Card>

          <Card className="p-8 text-center hover:shadow-xl transition-all duration-300 hover:-translate-y-2 bg-gradient-to-br from-white to-secondary-50/30 border-0">
            <div className="w-16 h-16 bg-gradient-to-br from-secondary-500 to-secondary-600 rounded-full flex items-center justify-center mx-auto mb-6 shadow-lg">
              <span className="text-2xl text-white">🤝</span>
            </div>
            <h3 className="text-xl font-bold text-gray-900 mb-4">Community Building</h3>
            <p className="text-gray-600 leading-relaxed">
              We foster a sense of community among students, connecting women from diverse backgrounds for support and inspiration.
            </p>
          </Card>

          <Card className="p-8 text-center hover:shadow-xl transition-all duration-300 hover:-translate-y-2 bg-gradient-to-br from-white to-primary-50/30 border-0">
            <div className="w-16 h-16 bg-gradient-to-br from-primary-600 to-secondary-600 rounded-full flex items-center justify-center mx-auto mb-6 shadow-lg">
              <span className="text-2xl text-white">🚀</span>
            </div>
            <h3 className="text-xl font-bold text-gray-900 mb-4">Empowerment Focus</h3>
            <p className="text-gray-600 leading-relaxed">
              Our programs cultivate a network of support, encouraging collaboration, inspiration, and empowerment among all students.
            </p>
          </Card>
        </div>
      </div>
    </section>
  );
}

export default ProgramOverview;
