import React from 'react';
import Link from 'next/link';
import Card from '@/components/common/ui/card';
import { Phone, Mail, MapPin, Clock } from 'lucide-react';

export function CallToAction() {
  const contactInfo = [
    {
      icon: Phone,
      title: "Call Us",
      info: "+93 785 675 793",
      action: "tel:+93785675793"
    },
    {
      icon: Mail,
      title: "Email Us",
      info: "paeyndah@gmail.com",
      action: "mailto:paeyndah@gmail.com"
    },
    {
      icon: MapPin,
      title: "Visit Us",
      info: "Kabul, Afghanistan",
      action: "#"
    },
    {
      icon: Clock,
      title: "School Hours",
      info: "Sun - Thu: 8:00 AM - 3:00 PM",
      action: "#"
    }
  ];

  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18 bg-gradient-to-br from-gray-50 via-white to-primary-50/30">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Main CTA Section */}
        <div className="text-center mb-16">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-8">
            🚀 Ready to Get Started?
          </div>
          
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 mb-8">
            Join Our Community of
            <span className="bg-gradient-to-r from-primary-600 to-secondary-600 bg-clip-text text-transparent"> Excellence</span>
          </h2>
          
          <p className="text-lg text-gray-600 mb-12 leading-relaxed max-w-3xl mx-auto">
            Experience the difference our comprehensive educational services can make in your child&apos;s journey. 
            Contact us today to learn more about enrollment and our programs.
          </p>

          <div className="flex flex-col sm:flex-row gap-6 justify-center mb-20">
            <Link href="/contact">
              <button className="bg-gradient-to-r from-primary-600 to-secondary-600 text-white px-8 py-4 rounded-xl font-semibold text-base hover:from-primary-500 hover:to-secondary-500 transition-all duration-300 shadow-2xl transform hover:-translate-y-1">
                Schedule a Visit
              </button>
            </Link>
            <button className="border-2 border-primary-300! text-primary-600 px-8 py-4 rounded-xl font-semibold text-base hover:bg-primary-50 hover:border-primary-400! transition-all duration-300">
              Download Brochure
            </button>
          </div>
        </div>

        {/* Contact Information Cards */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {contactInfo.map((contact, index) => (
            <Card key={index} className="bg-white border border-gray-200 hover:shadow-xl transition-all duration-300 group cursor-pointer hover:-translate-y-1">
              <div className="p-6 text-center">
                <div className="w-16 h-16 bg-gradient-to-r from-primary-500 to-secondary-500 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300 shadow-lg">
                  <contact.icon className="w-8 h-8 text-white" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900 mb-2">{contact.title}</h3>
                <p className="text-gray-600 text-sm leading-relaxed">{contact.info}</p>
              </div>
            </Card>
          ))}
        </div>

        {/* Bottom Section */}
        <div className="mt-16 text-center">
          <div className="bg-gradient-to-r from-primary-600 to-secondary-600 text-white rounded-2xl p-8 shadow-2xl">
            <h3 className="text-2xl md:text-3xl font-bold mb-4">
              Excellence in Education, Excellence in Life
            </h3>
            <p className="text-primary-100 leading-relaxed max-w-2xl mx-auto">
              Join thousands of families who have chosen Setaragan Zirak Private School for their children&apos;s education. 
              Together, we&apos;re building the leaders of tomorrow.
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}

export default CallToAction;
