'use client';

import React from 'react';
import Link from 'next/link';

export function HeroSection() {
  return (
    <section className="relative bg-gradient-to-br from-primary-50 via-white to-secondary-50 py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center max-w-4xl mx-auto">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-8">
            ✨ Comprehensive Educational Services
          </div>
          
          <h1 className="text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 mb-8">
            Nurturing
            <span className="bg-gradient-to-r from-primary-600 to-secondary-600 bg-clip-text text-transparent"> Excellence</span>
            <br />
            Beyond Academics
          </h1>
          
          <p className="text-lg text-gray-600 mb-12 leading-relaxed max-w-3xl mx-auto">
            At Setaragan Zirak Private School, we provide comprehensive services designed to nurture holistic development, 
            focusing on individual growth, social connections, emotional well-being, and lifelong learning.
          </p>

          <div className="flex flex-col sm:flex-row gap-6 justify-center">
            <button 
              onClick={() => {
                const servicesSection = document.getElementById('services-overview');
                if (servicesSection) {
                  servicesSection.scrollIntoView({ behavior: 'smooth' });
                }
              }}
              className="bg-gradient-to-r from-primary-600 to-secondary-600 text-white px-8 py-4 rounded-xl font-semibold text-base hover:from-primary-500 hover:to-secondary-500 transition-all duration-300 shadow-2xl transform hover:-translate-y-1"
            >
              Explore Our Services
            </button>
            <Link href="/contact">
              <button className="border-2 border-primary-300! text-primary-600 px-8 py-4 rounded-xl font-semibold text-base hover:bg-primary-50 hover:border-primary-400! transition-all duration-300">
              Contact Us
            </button>
            </Link>
          </div>
        </div>
      </div>

      {/* Floating Elements */}
      <div className="absolute top-20 left-10 w-20 h-20 bg-primary-400/20 rounded-full blur-xl animate-pulse"></div>
      <div className="absolute bottom-20 right-10 w-32 h-32 bg-secondary-400/20 rounded-full blur-xl animate-pulse delay-1000"></div>
      <div className="absolute top-1/2 left-1/4 w-16 h-16 bg-primary-300/20 rounded-full blur-xl animate-pulse delay-500"></div>
    </section>
  );
}

export default HeroSection;
