import React from 'react';
import { Trophy, Medal, Award, Star, Target, BookOpen } from 'lucide-react';

export function Achievements() {
  const achievements = [
    {
      icon: Trophy,
      title: "Math Olympiad Bronze Medal",
      description: "Mustafa Rezaee achieved Bronze Medal in the prestigious Math Olympiad competition",
      student: "Mustafa Rezaee",
      year: "1403"
    },
    {
      icon: Star,
      title: "Student of the Year 2024",
      description: "Ahmad Agha Noori recognized as the top student with outstanding academic performance",
      student: "Ahmad Agha Noori",
      year: "1403"
    },
    {
      icon: Medal,
      title: "First Place Overall Grades",
      description: "Bahara Noori secured the top position in overall grades for the academic year",
      student: "Bahara Noori",
      year: "1403"
    },
    {
      icon: Award,
      title: "Academic Excellence Recognition",
      description: "Multiple students received commendations for their dedication and hard work",
      student: "Various Students",
      year: "1403"
    },
    {
      icon: Target,
      title: "Olympiad Participation",
      description: "Ten outstanding students participated in the national Math Olympiad competition",
      student: "Olympiad Team",
      year: "1403"
    },
    {
      icon: BookOpen,
      title: "Consistent Academic Performance",
      description: "Students demonstrating excellence across all subjects and disciplines",
      student: "High Achievers",
      year: "Ongoing"
    }
  ];

  return (
    <section className="py-20 bg-gradient-to-br from-primary-50 to-secondary-50">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
            Celebrating Excellence
          </h2>
          <p className="text-lg text-gray-600 max-w-2xl mx-auto">
            Our students&apos; achievements reflect their dedication, hard work, and the nurturing
            environment that Setaragan Zirak provides for academic and personal growth.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {achievements.map((achievement, index) => {
            const IconComponent = achievement.icon;
            return (
              <div
                key={index}
                className="bg-white/80 backdrop-blur-sm rounded-2xl p-6 shadow-lg border border-gray-100 hover:shadow-xl transition-all duration-300 hover:-translate-y-1"
              >
                <div className='flex flex-col items-center justify-center'>
                  <div className="w-14 h-14 bg-gradient-to-br from-primary-100 to-secondary-100 rounded-xl flex items-center justify-center mb-4">
                    <IconComponent className="w-7 h-7 text-primary-600" />
                  </div>
                  <h3 className="text-xl font-semibold text-gray-900 mb-3">
                    {achievement.title}
                  </h3>
                </div>

                <p className="text-gray-600 mb-4 leading-relaxed">
                  {achievement.description}
                </p>

                <div className="flex items-center justify-between text-sm">
                  <span className="font-medium text-primary-600">
                    {achievement.student}
                  </span>
                  <span className="text-gray-500">
                    {achievement.year}
                  </span>
                </div>
              </div>
            );
          })}
        </div>

        <div className="mt-16 text-center">
          <div className="bg-white/70 backdrop-blur-sm rounded-2xl p-8 shadow-lg border border-gray-100 max-w-4xl mx-auto">
            <h3 className="text-2xl font-bold text-gray-900 mb-4">
              Our Commitment to Excellence
            </h3>
            <p className="text-gray-600 leading-relaxed mb-6">
              At Setaragan Zirak Private School, we believe that every student has the potential
              to achieve greatness. Through dedicated teaching, supportive learning environments,
              and opportunities for growth, we help our students realize their dreams and make
              meaningful contributions to their communities and beyond.
            </p>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6 text-center">
              <div>
                <div className="text-2xl font-bold text-primary-600 mb-2">100%</div>
                <div className="text-gray-600">Student Participation</div>
              </div>
              <div>
                <div className="text-2xl font-bold text-secondary-600 mb-2">10+</div>
                <div className="text-gray-600">Olympiad Participants</div>
              </div>
              <div>
                <div className="text-2xl font-bold text-green-600 mb-2">3</div>
                <div className="text-gray-600">Top Achievers Honored</div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

export default Achievements;
