import React from 'react';
import Link from 'next/link';
import { Heart, Users, BookOpen, ArrowRight } from 'lucide-react';

export function CallToAction() {
  return (
    <section className="py-20 bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 relative overflow-hidden">
      <div className="absolute inset-0 bg-black/10"></div>
      <div className="relative max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center text-white">
          <h2 className="text-3xl md:text-4xl font-bold mb-6">
            Let&apos;s Create Together
          </h2>

          <p className="text-lg mb-12 max-w-3xl mx-auto leading-relaxed opacity-90">
            Empowerment through Education: Setaragan Zirak is dedicated to uplifting
            underprivileged female students. Your donations pave the way for a brighter future for
            these young women. Support our cause and help shape a more inclusive tomorrow.
          </p>

          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-12">
            <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-6 border border-white/20">
              <Heart className="w-8 h-8 text-white mx-auto mb-4" />
              <h3 className="text-lg font-semibold mb-2">Support Education</h3>
              <p className="text-white/80 text-sm">
                Help provide quality education to students who need it most
              </p>
            </div>

            <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-6 border border-white/20">
              <Users className="w-8 h-8 text-white mx-auto mb-4" />
              <h3 className="text-lg font-semibold mb-2">Build Community</h3>
              <p className="text-white/80 text-sm">
                Create opportunities for students to thrive and succeed together
              </p>
            </div>

            <div className="bg-white/10 backdrop-blur-sm rounded-2xl p-6 border border-white/20">
              <BookOpen className="w-8 h-8 text-white mx-auto mb-4" />
              <h3 className="text-lg font-semibold mb-2">Shape Futures</h3>
              <p className="text-white/80 text-sm">
                Invest in the next generation of leaders and change-makers
              </p>
            </div>
          </div>

          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <Link
              href="/donate"
              className="inline-flex items-center bg-white text-primary-600 px-8 py-4 rounded-xl font-semibold text-base shadow-lg hover:shadow-xl transition-all duration-300 hover:scale-105 group"
            >
              ❤️ Donate Now
              <ArrowRight className="ml-2 w-5 h-5 transition-transform duration-300 group-hover:translate-x-1" />
            </Link>

            <div className="text-white/80 text-sm">
              Every contribution makes a difference
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

export default CallToAction;
