import React from 'react';
import Image from 'next/image';
import Card from '@/components/common/ui/card';
import Badge from '@/components/common/ui/badge';
import { Button } from '@/components/common/ui';
import Link from 'next/link';

export function StudentStories() {
  const stories = [
    {
      id: 1,
      title: "My Experience in the Math Olympiad (WMI)",
      author: "Mustafa 'Rezaie'",
      grade: "Fifth Grade",
      year: "1403",
      content: `I am Mustafa Rezaee, a fifth-grade student at Setaragan Zirak High School, in the academic year 1403. It has been my dream to attend this school since its founding, and my family helped me go through the necessary steps.

For three years now, I have been fortunate enough to be a student at this wonderful school. Both my parents, Mohammad Tahir Rezaee and my mother, hold professional jobs. During their working hours, my sister and I share the responsibility of household chores. I personally take care of all my father's duties until he returns home.

Guided by our loving parents, my sister and I strive to balance caring for our younger brother and sister with our own studies. At home, apart from my household responsibilities, I dedicate time to reviewing past lessons, assisting my brother with his studies, and respecting my older sister (who is two years and four months older than me).

My parents, teachers, and the school itself emphasize the importance of these duties, which I gladly accept. I have a special affinity for science subjects, particularly mathematics. When the school announced the Math Olympiad competition, I was thrilled and enthusiastically sought my father's permission to participate.

My parents were delighted and immediately signed the necessary forms. My father personally consulted with school officials and gathered all the relevant information. The school administration informed us about special training courses for the Olympiad. I eagerly devoted myself to the academic material each day. At home, my father also helped me with math, further fueling my passion.

I encountered numerous challenges, but I diligently worked toward overcoming them.`,
      images: [
        '/images/students/mustafa11.png',
        '/images/students/mustafa-4.jpg'
      ],
      achievement: "Bronze Medal Winner"
    },
    {
      id: 2,
      title: "Student of the Year (2024)",
      author: "Ahmad Agha 'Noori'",
      grade: "Top Student",
      year: "1403",
      content: `I, Ahmad Agha Noori, was born in 1391 Jagori in Ghazni province. Since 1400, I have had the privilege of pursuing my education at Setaragan Zirak High School, an institution that has played an instrumental role in shaping my academic journey.

Throughout these years, I have consistently excelled in my studies, earning recognition as the top student in my class. My dedication and hard work have been acknowledged through various awards and commendations, which serve as a testament to my commitment to excellence.

The educational experience at Setaragan Zirak High School has been nothing short of extraordinary. Each morning, I step into the school with a deep sense of enthusiasm and a thirst for knowledge that words alone cannot fully capture.

This institution has become more than just a place of learning for me; it is a nurturing environment where potential is cultivated and dreams take flight. One of the most inspiring aspects of my school experience is the passion and dedication of our teachers.

Their enthusiasm and commitment to education create an atmosphere that motivates every student to strive for greatness. The school goes beyond traditional school by offering a diverse array of activities, including cultural, social, and recreational programs.

These initiatives have played a pivotal role in shaping the holistic development of students, fostering a sense of community, and instilling invaluable life skills.`,
      images: [
        '/images/students/ahmad-1.png',
        '/images/students/ahmad-2.png'
      ],
      achievement: "Student of the Year 2024"
    },
    {
      id: 3,
      title: "A Journey of Dedication and Achievement",
      author: "Bahara 'Noori'",
      grade: "Fifth Grade",
      year: "1403",
      content: `My name is Bahara Noori, and I was born in 1392 (Solar Hijri) in the beautiful province of Ghazni. Currently, I am a proud fifth-grade student at Setaregan Zirak High School.

Since the school's inception, I have been deeply committed to my studies, and in 1403 (2024), I achieved a remarkable milestone: securing the top position in overall grades for the academic year.

From the outset of the academic year, I was determined to achieve first place in the final exams. This aspiration held immense significance for me, symbolizing the culmination of hard work and dedication.

I firmly believed that I could achieve any goal with focused effort and a well-structured plan. To turn my ambition into reality, I devised a detailed and disciplined study schedule.

Each subject demanded my attention, and I spent countless hours ensuring a deep understanding of the material. While I enjoyed all my classes, I devoted extra effort to subjects I found particularly challenging.

I viewed difficulties not as obstacles but as opportunities for growth, always seeking help from my teachers and classmates when I needed clarity.

Beyond my studies, I actively participated in group projects and collaborative learning. Helping my friends not only strengthened our relationships but also allowed me to learn from their perspectives.

These experiences instilled in me the value of teamwork, teaching me that we can achieve greater heights when we work together.`,
      images: [
        '/images/students/bahara33.png'
      ],
      achievement: "First Place Overall Grades"
    }
  ];

  return (
    <section className="py-8 sm:py-12 md:py-14 lg:py-16 xl:py-18md:py-14 lg:py-16 xl:py-18 bg-gradient-to-br from-gray-50 via-white to-primary-50/30">
      <div className="max-w-8xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-20">
          <div className="inline-flex items-center gap-2 bg-primary-100 text-primary-700 px-4 py-2 rounded-full text-sm font-medium mb-6">
            ✨ Student Excellence
          </div>
          <h2 className="text-2xl sm:text-3xl md:text-4xl font-bold leading-tight tracking-tight text-gray-900 mb-6">
            Inspiring Student 
            <span className="bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 bg-clip-text text-transparent"> Stories</span>
          </h2>
          <p className="text-lg text-gray-600 max-w-3xl mx-auto leading-relaxed">
            Discover the remarkable journeys of our exceptional students who demonstrate dedication,
            perseverance, and the pursuit of excellence in their academic endeavors.
          </p>
        </div>

        <div className="space-y-24">
          {stories.map((story, index) => (
            <div key={story.id} className="group">
              <Card className="overflow-hidden shadow-2xl border-0 bg-gradient-to-br from-white via-white to-primary-50/30 hover:shadow-3xl transition-all duration-500 hover:-translate-y-2">
                <div className="p-8 md:p-12 lg:p-16">
                  <div className={`flex flex-col ${index % 2 === 0 ? 'lg:flex-row' : 'lg:flex-row-reverse'} gap-12 lg:gap-16`}>
                    <div className="lg:w-2/3 space-y-8">
                      {/* Achievement Badges */}
                      <div className="flex flex-wrap items-center gap-3">
                        <Badge variant="secondary" className="bg-gradient-to-r from-primary-500 to-primary-600 text-white px-4 py-2 text-sm font-semibold">
                          🎓 {story.grade}
                        </Badge>
                        <Badge variant="outline" className="border-secondary-300 text-secondary-700 bg-secondary-50 px-4 py-2 text-sm font-semibold">
                          📅 {story.year}
                        </Badge>
                        <Badge variant="outline" className="border-green-300 text-green-700 bg-green-50 px-4 py-2 text-sm font-semibold">
                          🏆 {story.achievement}
                        </Badge>
                      </div>

                      {/* Story Header */}
                      <div className="space-y-4">
                        <h3 className="text-lg sm:text-xl lg:text-2xl font-bold text-gray-900 leading-tight group-hover:text-primary-600 transition-colors duration-300">
                          {story.title}
                        </h3>
                        
                        <div className="flex items-center gap-3">
                          <div className="w-12 h-12 bg-gradient-to-br from-primary-500 to-secondary-500 rounded-full flex items-center justify-center text-white font-bold text-lg shadow-lg">
                            {story.author.charAt(0)}
                          </div>
                          <div>
                            <p className="text-primary-600 font-semibold text-base">
                              {story.author}
                            </p>
                            <p className="text-gray-500 text-sm">
                              Setaragan Zirak High School
                            </p>
                          </div>
                        </div>
                      </div>

                      {/* Story Content */}
                      <div className="prose prose-lg max-w-none text-gray-700 leading-relaxed">
                        {story.content.split('\n\n').map((paragraph, idx) => (
                          <p key={idx} className="mb-6 text-gray-700 leading-relaxed text-sm md:text-base first:text-base sm:first:text-lg first:font-medium first:text-gray-800 ">
                            {idx === 0 && (
                              <span className="text-6xl font-bold text-primary-300 float-left mr-3 mt-2 leading-none">&ldquo;</span>
                            )}
                            {paragraph}
                          </p>
                        ))}
                        
                        {/* Quote ending */}
                        <div className="mt-8 p-6 bg-gradient-to-r from-primary-50 to-secondary-50 rounded-xl border-l-4 border-primary-400">
                          <p className="text-primary-700 font-medium italic">
                            &ldquo;This journey at Setaragan Zirak High School has shaped me into who I am today. 
                            Every challenge became an opportunity, and every achievement a stepping stone to greater dreams.&rdquo;
                          </p>
                        </div>
                      </div>
                    </div>

                    {/* Images Section */}
                    <div className="lg:w-1/3">
                      <div className="sticky top-8 space-y-6">
                        {story.images.map((image, imgIndex) => (
                          <div key={imgIndex} className="relative group/image">
                            <div className="relative aspect-[4/3] rounded-2xl overflow-hidden shadow-xl bg-gradient-to-br from-gray-100 to-gray-200">
                              <Image
                                src={image}
                                alt={`${story.author} - ${story.title}`}
                                fill
                                className="object-contain group-hover/image:scale-105 transition-transform duration-500"
                              />
                              {/* Overlay on hover */}
                              <div className="absolute inset-0 bg-gradient-to-t from-black/20 via-transparent to-transparent opacity-0 group-hover/image:opacity-100 transition-opacity duration-300" />
                            </div>
                            
                            {/* Image caption */}
                            <div className="mt-3 text-center">
                              <p className="text-sm text-gray-600 font-medium">
                                {imgIndex === 0 ? `${story.author}` : `Achievement Moment`}
                              </p>
                            </div>
                          </div>
                        ))}
                        
                        {/* Achievement highlight */}
                        <div className="bg-gradient-to-br from-primary-500 to-secondary-600 text-white p-6 rounded-2xl shadow-xl">
                          <div className="text-center">
                            <div className="text-3xl mb-3">🌟</div>
                            <h4 className="font-bold text-lg mb-2">Achievement Unlocked</h4>
                            <p className="text-primary-100 text-sm">
                              {story.achievement}
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </Card>
            </div>
          ))}
        </div>

        {/* Call to Action */}
        <div className="mt-24 text-center">
          <div className="bg-gradient-to-r from-primary-600 via-primary-500 to-secondary-600 text-white p-12 rounded-3xl shadow-2xl">
            <h3 className="text-2xl md:text-3xl font-bold mb-6">
              Write Your Own Success Story
            </h3>
            <p className="text-primary-100 text-lg mb-8 max-w-2xl mx-auto">
              Join our community of exceptional students and unlock your potential at Setaragan Zirak High School.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Link href="/admissions">
                <Button variant='outlined' className="bg-white!  text-primary-600! px-8 py-4 rounded-xl font-semibold hover:bg-gray-50! transition-colors duration-300 shadow-lg">
                Apply Now
              </Button>
              </Link>
              <Link href="/about">
              <Button variant='outlined' className=" text-white! border-white! px-8 py-4 rounded-xl font-semibold hover:bg-white hover:text-primary-600! transition-colors duration-300">
                Learn More
              </Button>
              </Link>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

export default StudentStories;
