'use client';

import React, { useState } from 'react';
import Image from 'next/image';

interface TeacherImageProps {
  src: string;
  alt: string;
  width?: number;
  height?: number;
  fill?: boolean;
  className?: string;
  priority?: boolean;
}

export default function TeacherImage({ 
  src, 
  alt, 
  width, 
  height, 
  fill, 
  className, 
  priority 
}: TeacherImageProps) {
  const [imageSrc, setImageSrc] = useState(src);

  const handleError = () => {
    const initials = alt.split(' ').map(n => n[0]).join('');
    const size = width || height || 320;
    const fallbackSrc = `data:image/svg+xml;base64,${btoa(
      `<svg width="${size}" height="${size}" xmlns="http://www.w3.org/2000/svg"><rect width="${size}" height="${size}" fill="#f3f4f6"/><text x="50%" y="50%" font-family="system-ui" font-size="${Math.floor(size/13)}" fill="#6b7280" text-anchor="middle" dy=".3em">${initials}</text></svg>`
    )}`;
    setImageSrc(fallbackSrc);
  };

  return (
    <Image
      src={imageSrc}
      alt={alt}
      width={width}
      height={height}
      fill={fill}
      className={className}
      priority={priority}
      onError={handleError}
    />
  );
}