"use client";

import { Session } from "next-auth";
import { useSession } from "next-auth/react";
import React, { createContext, useContext, ReactNode, useMemo } from "react";

interface AuthContextType {
  session: Session | null;
  user: Session["user"] | null;
  isLoading: boolean;
  isAuthenticated: boolean;
}

const AuthContext = createContext<AuthContextType | undefined>(undefined);

export function AuthProvider({ children }: { children: ReactNode }) {
  const { data: session, status } = useSession();

  const value: AuthContextType = useMemo(
    () => ({
      session: session || null,
      user: session?.user || null,
      isLoading: status === "loading",
      isAuthenticated: status === "authenticated",
    }),
    [session, status]
  );

  return <AuthContext.Provider value={value}>{children}</AuthContext.Provider>;
}

export function useAuth(): AuthContextType {
  const context = useContext(AuthContext);
  if (context === undefined) {
    throw new Error("useAuth must be used within AuthProvider");
  }
  return context;
}
